/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.excelant;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import org.apache.poi.ss.excelant.ExcelAntPrecision;
import org.apache.poi.ss.excelant.ExcelAntTest;
import org.apache.poi.ss.excelant.ExcelAntUserDefinedFunction;
import org.apache.poi.ss.excelant.util.ExcelAntWorkbookUtil;
import org.apache.poi.ss.excelant.util.ExcelAntWorkbookUtilFactory;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class ExcelAntTask
extends Task {
    public static final String VERSION = "0.5.0";
    private String excelFileName;
    private boolean failOnError = false;
    private ExcelAntWorkbookUtil workbookUtil;
    private ExcelAntPrecision precision;
    private LinkedList<ExcelAntTest> tests = new LinkedList();
    private LinkedList<ExcelAntUserDefinedFunction> functions = new LinkedList();

    public void addPrecision(ExcelAntPrecision prec) {
        this.precision = prec;
    }

    public void setFailOnError(boolean value) {
        this.failOnError = value;
    }

    public void setFileName(String fileName) {
        this.excelFileName = fileName;
    }

    public void addTest(ExcelAntTest testElement) {
        this.tests.add(testElement);
    }

    public void addUdf(ExcelAntUserDefinedFunction def) {
        this.functions.add(def);
    }

    public void execute() throws BuildException {
        this.checkClassPath();
        int totalCount = 0;
        int successCount = 0;
        StringBuffer versionBffr = new StringBuffer();
        versionBffr.append("ExcelAnt version ");
        versionBffr.append(VERSION);
        versionBffr.append(" Copyright 2011");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
        double currYear = Double.parseDouble(sdf.format(new Date()));
        if (currYear > 2011.0) {
            versionBffr.append("-");
            versionBffr.append(currYear);
        }
        this.log(versionBffr.toString(), 2);
        this.log("Using input file: " + this.excelFileName, 2);
        Workbook targetWorkbook = this.loadWorkbook();
        if (targetWorkbook == null) {
            this.log("Unable to load " + this.excelFileName + ".  Verify the file exists and can be read.", 0);
            return;
        }
        if (this.tests != null && this.tests.size() > 0) {
            for (ExcelAntTest test : this.tests) {
                this.log("executing test: " + test.getName(), 4);
                this.workbookUtil = ExcelAntWorkbookUtilFactory.getInstance(this.excelFileName);
                if (this.functions != null) {
                    for (ExcelAntUserDefinedFunction eaUdf : this.functions) {
                        try {
                            this.workbookUtil.addFunction(eaUdf.getFunctionAlias(), eaUdf.getClassName());
                        }
                        catch (Exception e) {
                            throw new BuildException(e.getMessage(), (Throwable)e);
                        }
                    }
                }
                test.setWorkbookUtil(this.workbookUtil);
                if (this.precision != null && this.precision.getValue() > 0.0) {
                    this.log("setting precision for the test " + test.getName(), 3);
                    test.setPrecision(this.precision.getValue());
                }
                test.execute();
                if (test.didTestPass()) {
                    ++successCount;
                } else if (this.failOnError) {
                    throw new BuildException("Test " + test.getName() + " failed.");
                }
                ++totalCount;
                this.workbookUtil = null;
            }
            this.log(successCount + "/" + totalCount + " tests passed.", 2);
            this.workbookUtil = null;
        }
    }

    private Workbook loadWorkbook() {
        Workbook workbook;
        if (this.excelFileName == null) {
            throw new BuildException("fileName attribute must be set!", this.getLocation());
        }
        File workbookFile = new File(this.excelFileName);
        try {
            FileInputStream fis = new FileInputStream(workbookFile);
            workbook = WorkbookFactory.create((InputStream)fis);
        }
        catch (Exception e) {
            throw new BuildException("Cannot load file " + this.excelFileName + ". Make sure the path and file permissions are correct.", (Throwable)e, this.getLocation());
        }
        return workbook;
    }

    private void checkClassPath() {
        try {
            Class.forName("org.apache.poi.hssf.usermodel.HSSFWorkbook");
            Class.forName("org.apache.poi.ss.usermodel.WorkbookFactory");
        }
        catch (Throwable e) {
            throw new BuildException("The <classpath> for <excelant> must include poi.jar and poi-ooxml.jar if not in Ant's own classpath. Processing .xlsx spreadsheets requires additional poi-ooxml-schemas.jar, xmlbeans.jar and dom4j.jar", e, this.getLocation());
        }
    }
}

