/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileDeleteStrategy;
import org.apache.commons.io.testtools.FileBasedTestCase;

public class FileDeleteStrategyTestCase
extends FileBasedTestCase {
    public FileDeleteStrategyTestCase(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testDeleteNormal() throws Exception {
        File baseDir = FileDeleteStrategyTestCase.getTestDirectory();
        File subDir = new File(baseDir, "test");
        FileDeleteStrategyTestCase.assertTrue((boolean)subDir.mkdir());
        File subFile = new File(subDir, "a.txt");
        this.createFile(subFile, 16L);
        FileDeleteStrategyTestCase.assertTrue((boolean)subDir.exists());
        FileDeleteStrategyTestCase.assertTrue((boolean)subFile.exists());
        try {
            FileDeleteStrategy.NORMAL.delete(subDir);
            FileDeleteStrategyTestCase.fail();
        }
        catch (IOException ex) {
            // empty catch block
        }
        FileDeleteStrategyTestCase.assertTrue((boolean)subDir.exists());
        FileDeleteStrategyTestCase.assertTrue((boolean)subFile.exists());
        FileDeleteStrategy.NORMAL.delete(subFile);
        FileDeleteStrategyTestCase.assertTrue((boolean)subDir.exists());
        FileDeleteStrategyTestCase.assertFalse((boolean)subFile.exists());
        FileDeleteStrategy.NORMAL.delete(subDir);
        FileDeleteStrategyTestCase.assertFalse((boolean)subDir.exists());
        FileDeleteStrategy.NORMAL.delete(subDir);
        FileDeleteStrategyTestCase.assertFalse((boolean)subDir.exists());
    }

    public void testDeleteQuietlyNormal() throws Exception {
        File baseDir = FileDeleteStrategyTestCase.getTestDirectory();
        File subDir = new File(baseDir, "test");
        FileDeleteStrategyTestCase.assertTrue((boolean)subDir.mkdir());
        File subFile = new File(subDir, "a.txt");
        this.createFile(subFile, 16L);
        FileDeleteStrategyTestCase.assertTrue((boolean)subDir.exists());
        FileDeleteStrategyTestCase.assertTrue((boolean)subFile.exists());
        FileDeleteStrategyTestCase.assertFalse((boolean)FileDeleteStrategy.NORMAL.deleteQuietly(subDir));
        FileDeleteStrategyTestCase.assertTrue((boolean)subDir.exists());
        FileDeleteStrategyTestCase.assertTrue((boolean)subFile.exists());
        FileDeleteStrategyTestCase.assertTrue((boolean)FileDeleteStrategy.NORMAL.deleteQuietly(subFile));
        FileDeleteStrategyTestCase.assertTrue((boolean)subDir.exists());
        FileDeleteStrategyTestCase.assertFalse((boolean)subFile.exists());
        FileDeleteStrategyTestCase.assertTrue((boolean)FileDeleteStrategy.NORMAL.deleteQuietly(subDir));
        FileDeleteStrategyTestCase.assertFalse((boolean)subDir.exists());
        FileDeleteStrategyTestCase.assertTrue((boolean)FileDeleteStrategy.NORMAL.deleteQuietly(subDir));
        FileDeleteStrategyTestCase.assertFalse((boolean)subDir.exists());
    }

    public void testDeleteForce() throws Exception {
        File baseDir = FileDeleteStrategyTestCase.getTestDirectory();
        File subDir = new File(baseDir, "test");
        FileDeleteStrategyTestCase.assertTrue((boolean)subDir.mkdir());
        File subFile = new File(subDir, "a.txt");
        this.createFile(subFile, 16L);
        FileDeleteStrategyTestCase.assertTrue((boolean)subDir.exists());
        FileDeleteStrategyTestCase.assertTrue((boolean)subFile.exists());
        FileDeleteStrategy.FORCE.delete(subDir);
        FileDeleteStrategyTestCase.assertFalse((boolean)subDir.exists());
        FileDeleteStrategyTestCase.assertFalse((boolean)subFile.exists());
        FileDeleteStrategy.FORCE.delete(subDir);
        FileDeleteStrategyTestCase.assertFalse((boolean)subDir.exists());
    }

    public void testDeleteNull() throws Exception {
        try {
            FileDeleteStrategy.NORMAL.delete((File)null);
            FileDeleteStrategyTestCase.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        FileDeleteStrategyTestCase.assertTrue((boolean)FileDeleteStrategy.NORMAL.deleteQuietly((File)null));
    }

    public void testToString() {
        FileDeleteStrategyTestCase.assertEquals((String)"FileDeleteStrategy[Normal]", (String)FileDeleteStrategy.NORMAL.toString());
        FileDeleteStrategyTestCase.assertEquals((String)"FileDeleteStrategy[Force]", (String)FileDeleteStrategy.FORCE.toString());
    }
}

