/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.File;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.testtools.FileBasedTestCase;

public class FileUtilsCleanSymlinksTestCase
extends FileBasedTestCase {
    final File top = FileUtilsCleanSymlinksTestCase.getTestDirectory();

    public FileUtilsCleanSymlinksTestCase(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.top.mkdirs();
    }

    protected void tearDown() throws Exception {
        FileUtils.deleteDirectory((File)this.top);
    }

    public void testCleanDirWithSymlinkFile() throws Exception {
        if (System.getProperty("os.name").startsWith("Win")) {
            return;
        }
        File realOuter = new File(this.top, "realouter");
        FileUtilsCleanSymlinksTestCase.assertTrue((boolean)realOuter.mkdirs());
        File realInner = new File(realOuter, "realinner");
        FileUtilsCleanSymlinksTestCase.assertTrue((boolean)realInner.mkdirs());
        File realFile = new File(realInner, "file1");
        FileUtils.touch((File)realFile);
        FileUtilsCleanSymlinksTestCase.assertEquals((int)1, (int)realInner.list().length);
        File randomFile = new File(this.top, "randomfile");
        FileUtils.touch((File)randomFile);
        File symlinkFile = new File(realInner, "fakeinner");
        this.setupSymlink(randomFile, symlinkFile);
        FileUtilsCleanSymlinksTestCase.assertEquals((int)2, (int)realInner.list().length);
        FileUtils.cleanDirectory((File)realOuter);
        FileUtilsCleanSymlinksTestCase.assertEquals((int)0, (int)realOuter.list().length);
        FileUtilsCleanSymlinksTestCase.assertTrue((boolean)randomFile.exists());
        FileUtilsCleanSymlinksTestCase.assertFalse((boolean)symlinkFile.exists());
    }

    public void testCleanDirWithASymlinkDir() throws Exception {
        if (System.getProperty("os.name").startsWith("Win")) {
            return;
        }
        File realOuter = new File(this.top, "realouter");
        FileUtilsCleanSymlinksTestCase.assertTrue((boolean)realOuter.mkdirs());
        File realInner = new File(realOuter, "realinner");
        FileUtilsCleanSymlinksTestCase.assertTrue((boolean)realInner.mkdirs());
        FileUtils.touch((File)new File(realInner, "file1"));
        FileUtilsCleanSymlinksTestCase.assertEquals((int)1, (int)realInner.list().length);
        File randomDirectory = new File(this.top, "randomDir");
        FileUtilsCleanSymlinksTestCase.assertTrue((boolean)randomDirectory.mkdirs());
        FileUtils.touch((File)new File(randomDirectory, "randomfile"));
        FileUtilsCleanSymlinksTestCase.assertEquals((int)1, (int)randomDirectory.list().length);
        File symlinkDirectory = new File(realOuter, "fakeinner");
        this.setupSymlink(randomDirectory, symlinkDirectory);
        FileUtilsCleanSymlinksTestCase.assertEquals((int)1, (int)symlinkDirectory.list().length);
        FileUtils.cleanDirectory((File)realOuter);
        FileUtilsCleanSymlinksTestCase.assertEquals((int)0, (int)realOuter.list().length);
        FileUtilsCleanSymlinksTestCase.assertEquals((String)"Contents of sym link should not have been removed", (int)1, (int)randomDirectory.list().length);
    }

    public void testCleanDirWithParentSymlinks() throws Exception {
        if (System.getProperty("os.name").startsWith("Win")) {
            return;
        }
        File realParent = new File(this.top, "realparent");
        FileUtilsCleanSymlinksTestCase.assertTrue((boolean)realParent.mkdirs());
        File realInner = new File(realParent, "realinner");
        FileUtilsCleanSymlinksTestCase.assertTrue((boolean)realInner.mkdirs());
        FileUtils.touch((File)new File(realInner, "file1"));
        FileUtilsCleanSymlinksTestCase.assertEquals((int)1, (int)realInner.list().length);
        File randomDirectory = new File(this.top, "randomDir");
        FileUtilsCleanSymlinksTestCase.assertTrue((boolean)randomDirectory.mkdirs());
        FileUtils.touch((File)new File(randomDirectory, "randomfile"));
        FileUtilsCleanSymlinksTestCase.assertEquals((int)1, (int)randomDirectory.list().length);
        File symlinkDirectory = new File(realParent, "fakeinner");
        this.setupSymlink(randomDirectory, symlinkDirectory);
        FileUtilsCleanSymlinksTestCase.assertEquals((int)1, (int)symlinkDirectory.list().length);
        File symlinkParentDirectory = new File(this.top, "fakeouter");
        this.setupSymlink(realParent, symlinkParentDirectory);
        FileUtils.cleanDirectory((File)symlinkParentDirectory);
        FileUtilsCleanSymlinksTestCase.assertEquals((int)0, (int)symlinkParentDirectory.list().length);
        FileUtilsCleanSymlinksTestCase.assertEquals((int)0, (int)realParent.list().length);
        FileUtilsCleanSymlinksTestCase.assertEquals((String)"Contents of sym link should not have been removed", (int)1, (int)randomDirectory.list().length);
    }

    public void testStillClearsIfGivenDirectoryIsASymlink() throws Exception {
        if (System.getProperty("os.name").startsWith("Win")) {
            return;
        }
        File randomDirectory = new File(this.top, "randomDir");
        FileUtilsCleanSymlinksTestCase.assertTrue((boolean)randomDirectory.mkdirs());
        FileUtils.touch((File)new File(randomDirectory, "randomfile"));
        FileUtilsCleanSymlinksTestCase.assertEquals((int)1, (int)randomDirectory.list().length);
        File symlinkDirectory = new File(this.top, "fakeDir");
        this.setupSymlink(randomDirectory, symlinkDirectory);
        FileUtils.cleanDirectory((File)symlinkDirectory);
        FileUtilsCleanSymlinksTestCase.assertEquals((int)0, (int)symlinkDirectory.list().length);
        FileUtilsCleanSymlinksTestCase.assertEquals((int)0, (int)randomDirectory.list().length);
    }

    public void testIdentifiesSymlinkDir() throws Exception {
        if (System.getProperty("os.name").startsWith("Win")) {
            return;
        }
        File randomDirectory = new File(this.top, "randomDir");
        FileUtilsCleanSymlinksTestCase.assertTrue((boolean)randomDirectory.mkdirs());
        File symlinkDirectory = new File(this.top, "fakeDir");
        this.setupSymlink(randomDirectory, symlinkDirectory);
        FileUtilsCleanSymlinksTestCase.assertTrue((boolean)FileUtils.isSymlink((File)symlinkDirectory));
        FileUtilsCleanSymlinksTestCase.assertFalse((boolean)FileUtils.isSymlink((File)randomDirectory));
    }

    public void testIdentifiesSymlinkFile() throws Exception {
        if (System.getProperty("os.name").startsWith("Win")) {
            return;
        }
        File randomFile = new File(this.top, "randomfile");
        FileUtils.touch((File)randomFile);
        File symlinkFile = new File(this.top, "fakeinner");
        this.setupSymlink(randomFile, symlinkFile);
        FileUtilsCleanSymlinksTestCase.assertTrue((boolean)FileUtils.isSymlink((File)symlinkFile));
        FileUtilsCleanSymlinksTestCase.assertFalse((boolean)FileUtils.isSymlink((File)randomFile));
    }

    public void testCorrectlyIdentifySymlinkWithParentSymLink() throws Exception {
        if (System.getProperty("os.name").startsWith("Win")) {
            return;
        }
        File realParent = new File(this.top, "realparent");
        FileUtilsCleanSymlinksTestCase.assertTrue((boolean)realParent.mkdirs());
        File symlinkParentDirectory = new File(this.top, "fakeparent");
        this.setupSymlink(realParent, symlinkParentDirectory);
        File realChild = new File(symlinkParentDirectory, "realChild");
        FileUtilsCleanSymlinksTestCase.assertTrue((boolean)realChild.mkdirs());
        File symlinkChild = new File(symlinkParentDirectory, "fakeChild");
        this.setupSymlink(realChild, symlinkChild);
        FileUtilsCleanSymlinksTestCase.assertTrue((boolean)FileUtils.isSymlink((File)symlinkChild));
        FileUtilsCleanSymlinksTestCase.assertFalse((boolean)FileUtils.isSymlink((File)realChild));
    }

    private void setupSymlink(File res, File link) throws Exception {
        ArrayList<String> args = new ArrayList<String>();
        args.add("ln");
        args.add("-s");
        args.add(res.getAbsolutePath());
        args.add(link.getAbsolutePath());
        Process proc = Runtime.getRuntime().exec(args.toArray(new String[args.size()]));
        proc.waitFor();
    }
}

