/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.testtools.FileBasedTestCase;

public class IOCaseTestCase
extends FileBasedTestCase {
    private static final boolean WINDOWS = File.separatorChar == '\\';

    public IOCaseTestCase(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public void test_forName() throws Exception {
        IOCaseTestCase.assertEquals((Object)IOCase.SENSITIVE, (Object)IOCase.forName((String)"Sensitive"));
        IOCaseTestCase.assertEquals((Object)IOCase.INSENSITIVE, (Object)IOCase.forName((String)"Insensitive"));
        IOCaseTestCase.assertEquals((Object)IOCase.SYSTEM, (Object)IOCase.forName((String)"System"));
        try {
            IOCase.forName((String)"Blah");
            IOCaseTestCase.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            IOCase.forName(null);
            IOCaseTestCase.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void test_serialization() throws Exception {
        IOCaseTestCase.assertSame((Object)IOCase.SENSITIVE, (Object)this.serialize(IOCase.SENSITIVE));
        IOCaseTestCase.assertSame((Object)IOCase.INSENSITIVE, (Object)this.serialize(IOCase.INSENSITIVE));
        IOCaseTestCase.assertSame((Object)IOCase.SYSTEM, (Object)this.serialize(IOCase.SYSTEM));
    }

    public void test_getName() throws Exception {
        IOCaseTestCase.assertEquals((String)"Sensitive", (String)IOCase.SENSITIVE.getName());
        IOCaseTestCase.assertEquals((String)"Insensitive", (String)IOCase.INSENSITIVE.getName());
        IOCaseTestCase.assertEquals((String)"System", (String)IOCase.SYSTEM.getName());
    }

    public void test_toString() throws Exception {
        IOCaseTestCase.assertEquals((String)"Sensitive", (String)IOCase.SENSITIVE.toString());
        IOCaseTestCase.assertEquals((String)"Insensitive", (String)IOCase.INSENSITIVE.toString());
        IOCaseTestCase.assertEquals((String)"System", (String)IOCase.SYSTEM.toString());
    }

    public void test_isCaseSensitive() throws Exception {
        IOCaseTestCase.assertTrue((boolean)IOCase.SENSITIVE.isCaseSensitive());
        IOCaseTestCase.assertFalse((boolean)IOCase.INSENSITIVE.isCaseSensitive());
        IOCaseTestCase.assertEquals((!WINDOWS ? 1 : 0) != 0, (boolean)IOCase.SYSTEM.isCaseSensitive());
    }

    public void test_checkCompare_functionality() throws Exception {
        IOCaseTestCase.assertTrue((IOCase.SENSITIVE.checkCompareTo("ABC", "") > 0 ? 1 : 0) != 0);
        IOCaseTestCase.assertTrue((IOCase.SENSITIVE.checkCompareTo("", "ABC") < 0 ? 1 : 0) != 0);
        IOCaseTestCase.assertTrue((IOCase.SENSITIVE.checkCompareTo("ABC", "DEF") < 0 ? 1 : 0) != 0);
        IOCaseTestCase.assertTrue((IOCase.SENSITIVE.checkCompareTo("DEF", "ABC") > 0 ? 1 : 0) != 0);
        IOCaseTestCase.assertEquals((int)0, (int)IOCase.SENSITIVE.checkCompareTo("ABC", "ABC"));
        IOCaseTestCase.assertEquals((int)0, (int)IOCase.SENSITIVE.checkCompareTo("", ""));
        try {
            IOCase.SENSITIVE.checkCompareTo("ABC", null);
            IOCaseTestCase.fail();
        }
        catch (NullPointerException ex) {
            // empty catch block
        }
        try {
            IOCase.SENSITIVE.checkCompareTo(null, "ABC");
            IOCaseTestCase.fail();
        }
        catch (NullPointerException ex) {
            // empty catch block
        }
        try {
            IOCase.SENSITIVE.checkCompareTo(null, null);
            IOCaseTestCase.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void test_checkCompare_case() throws Exception {
        IOCaseTestCase.assertEquals((int)0, (int)IOCase.SENSITIVE.checkCompareTo("ABC", "ABC"));
        IOCaseTestCase.assertTrue((IOCase.SENSITIVE.checkCompareTo("ABC", "abc") < 0 ? 1 : 0) != 0);
        IOCaseTestCase.assertTrue((IOCase.SENSITIVE.checkCompareTo("abc", "ABC") > 0 ? 1 : 0) != 0);
        IOCaseTestCase.assertEquals((int)0, (int)IOCase.INSENSITIVE.checkCompareTo("ABC", "ABC"));
        IOCaseTestCase.assertEquals((int)0, (int)IOCase.INSENSITIVE.checkCompareTo("ABC", "abc"));
        IOCaseTestCase.assertEquals((int)0, (int)IOCase.INSENSITIVE.checkCompareTo("abc", "ABC"));
        IOCaseTestCase.assertEquals((int)0, (int)IOCase.SYSTEM.checkCompareTo("ABC", "ABC"));
        IOCaseTestCase.assertEquals((boolean)WINDOWS, (IOCase.SYSTEM.checkCompareTo("ABC", "abc") == 0 ? 1 : 0) != 0);
        IOCaseTestCase.assertEquals((boolean)WINDOWS, (IOCase.SYSTEM.checkCompareTo("abc", "ABC") == 0 ? 1 : 0) != 0);
    }

    public void test_checkEquals_functionality() throws Exception {
        IOCaseTestCase.assertFalse((boolean)IOCase.SENSITIVE.checkEquals("ABC", ""));
        IOCaseTestCase.assertFalse((boolean)IOCase.SENSITIVE.checkEquals("ABC", "A"));
        IOCaseTestCase.assertFalse((boolean)IOCase.SENSITIVE.checkEquals("ABC", "AB"));
        IOCaseTestCase.assertTrue((boolean)IOCase.SENSITIVE.checkEquals("ABC", "ABC"));
        IOCaseTestCase.assertFalse((boolean)IOCase.SENSITIVE.checkEquals("ABC", "BC"));
        IOCaseTestCase.assertFalse((boolean)IOCase.SENSITIVE.checkEquals("ABC", "C"));
        IOCaseTestCase.assertFalse((boolean)IOCase.SENSITIVE.checkEquals("ABC", "ABCD"));
        IOCaseTestCase.assertFalse((boolean)IOCase.SENSITIVE.checkEquals("", "ABC"));
        IOCaseTestCase.assertTrue((boolean)IOCase.SENSITIVE.checkEquals("", ""));
        try {
            IOCase.SENSITIVE.checkEquals("ABC", null);
            IOCaseTestCase.fail();
        }
        catch (NullPointerException ex) {
            // empty catch block
        }
        try {
            IOCase.SENSITIVE.checkEquals(null, "ABC");
            IOCaseTestCase.fail();
        }
        catch (NullPointerException ex) {
            // empty catch block
        }
        try {
            IOCase.SENSITIVE.checkEquals(null, null);
            IOCaseTestCase.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void test_checkEquals_case() throws Exception {
        IOCaseTestCase.assertTrue((boolean)IOCase.SENSITIVE.checkEquals("ABC", "ABC"));
        IOCaseTestCase.assertFalse((boolean)IOCase.SENSITIVE.checkEquals("ABC", "Abc"));
        IOCaseTestCase.assertTrue((boolean)IOCase.INSENSITIVE.checkEquals("ABC", "ABC"));
        IOCaseTestCase.assertTrue((boolean)IOCase.INSENSITIVE.checkEquals("ABC", "Abc"));
        IOCaseTestCase.assertTrue((boolean)IOCase.SYSTEM.checkEquals("ABC", "ABC"));
        IOCaseTestCase.assertEquals((boolean)WINDOWS, (boolean)IOCase.SYSTEM.checkEquals("ABC", "Abc"));
    }

    public void test_checkStartsWith_functionality() throws Exception {
        IOCaseTestCase.assertTrue((boolean)IOCase.SENSITIVE.checkStartsWith("ABC", ""));
        IOCaseTestCase.assertTrue((boolean)IOCase.SENSITIVE.checkStartsWith("ABC", "A"));
        IOCaseTestCase.assertTrue((boolean)IOCase.SENSITIVE.checkStartsWith("ABC", "AB"));
        IOCaseTestCase.assertTrue((boolean)IOCase.SENSITIVE.checkStartsWith("ABC", "ABC"));
        IOCaseTestCase.assertFalse((boolean)IOCase.SENSITIVE.checkStartsWith("ABC", "BC"));
        IOCaseTestCase.assertFalse((boolean)IOCase.SENSITIVE.checkStartsWith("ABC", "C"));
        IOCaseTestCase.assertFalse((boolean)IOCase.SENSITIVE.checkStartsWith("ABC", "ABCD"));
        IOCaseTestCase.assertFalse((boolean)IOCase.SENSITIVE.checkStartsWith("", "ABC"));
        IOCaseTestCase.assertTrue((boolean)IOCase.SENSITIVE.checkStartsWith("", ""));
        try {
            IOCase.SENSITIVE.checkStartsWith("ABC", null);
            IOCaseTestCase.fail();
        }
        catch (NullPointerException ex) {
            // empty catch block
        }
        try {
            IOCase.SENSITIVE.checkStartsWith(null, "ABC");
            IOCaseTestCase.fail();
        }
        catch (NullPointerException ex) {
            // empty catch block
        }
        try {
            IOCase.SENSITIVE.checkStartsWith(null, null);
            IOCaseTestCase.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void test_checkStartsWith_case() throws Exception {
        IOCaseTestCase.assertTrue((boolean)IOCase.SENSITIVE.checkStartsWith("ABC", "AB"));
        IOCaseTestCase.assertFalse((boolean)IOCase.SENSITIVE.checkStartsWith("ABC", "Ab"));
        IOCaseTestCase.assertTrue((boolean)IOCase.INSENSITIVE.checkStartsWith("ABC", "AB"));
        IOCaseTestCase.assertTrue((boolean)IOCase.INSENSITIVE.checkStartsWith("ABC", "Ab"));
        IOCaseTestCase.assertTrue((boolean)IOCase.SYSTEM.checkStartsWith("ABC", "AB"));
        IOCaseTestCase.assertEquals((boolean)WINDOWS, (boolean)IOCase.SYSTEM.checkStartsWith("ABC", "Ab"));
    }

    public void test_checkEndsWith_functionality() throws Exception {
        IOCaseTestCase.assertTrue((boolean)IOCase.SENSITIVE.checkEndsWith("ABC", ""));
        IOCaseTestCase.assertFalse((boolean)IOCase.SENSITIVE.checkEndsWith("ABC", "A"));
        IOCaseTestCase.assertFalse((boolean)IOCase.SENSITIVE.checkEndsWith("ABC", "AB"));
        IOCaseTestCase.assertTrue((boolean)IOCase.SENSITIVE.checkEndsWith("ABC", "ABC"));
        IOCaseTestCase.assertTrue((boolean)IOCase.SENSITIVE.checkEndsWith("ABC", "BC"));
        IOCaseTestCase.assertTrue((boolean)IOCase.SENSITIVE.checkEndsWith("ABC", "C"));
        IOCaseTestCase.assertFalse((boolean)IOCase.SENSITIVE.checkEndsWith("ABC", "ABCD"));
        IOCaseTestCase.assertFalse((boolean)IOCase.SENSITIVE.checkEndsWith("", "ABC"));
        IOCaseTestCase.assertTrue((boolean)IOCase.SENSITIVE.checkEndsWith("", ""));
        try {
            IOCase.SENSITIVE.checkEndsWith("ABC", null);
            IOCaseTestCase.fail();
        }
        catch (NullPointerException ex) {
            // empty catch block
        }
        try {
            IOCase.SENSITIVE.checkEndsWith(null, "ABC");
            IOCaseTestCase.fail();
        }
        catch (NullPointerException ex) {
            // empty catch block
        }
        try {
            IOCase.SENSITIVE.checkEndsWith(null, null);
            IOCaseTestCase.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void test_checkEndsWith_case() throws Exception {
        IOCaseTestCase.assertTrue((boolean)IOCase.SENSITIVE.checkEndsWith("ABC", "BC"));
        IOCaseTestCase.assertFalse((boolean)IOCase.SENSITIVE.checkEndsWith("ABC", "Bc"));
        IOCaseTestCase.assertTrue((boolean)IOCase.INSENSITIVE.checkEndsWith("ABC", "BC"));
        IOCaseTestCase.assertTrue((boolean)IOCase.INSENSITIVE.checkEndsWith("ABC", "Bc"));
        IOCaseTestCase.assertTrue((boolean)IOCase.SYSTEM.checkEndsWith("ABC", "BC"));
        IOCaseTestCase.assertEquals((boolean)WINDOWS, (boolean)IOCase.SYSTEM.checkEndsWith("ABC", "Bc"));
    }

    public void test_checkIndexOf_functionality() throws Exception {
        IOCaseTestCase.assertEquals((int)0, (int)IOCase.SENSITIVE.checkIndexOf("ABCDEFGHIJ", 0, "A"));
        IOCaseTestCase.assertEquals((int)-1, (int)IOCase.SENSITIVE.checkIndexOf("ABCDEFGHIJ", 1, "A"));
        IOCaseTestCase.assertEquals((int)0, (int)IOCase.SENSITIVE.checkIndexOf("ABCDEFGHIJ", 0, "AB"));
        IOCaseTestCase.assertEquals((int)-1, (int)IOCase.SENSITIVE.checkIndexOf("ABCDEFGHIJ", 1, "AB"));
        IOCaseTestCase.assertEquals((int)0, (int)IOCase.SENSITIVE.checkIndexOf("ABCDEFGHIJ", 0, "ABC"));
        IOCaseTestCase.assertEquals((int)-1, (int)IOCase.SENSITIVE.checkIndexOf("ABCDEFGHIJ", 1, "ABC"));
        IOCaseTestCase.assertEquals((int)3, (int)IOCase.SENSITIVE.checkIndexOf("ABCDEFGHIJ", 0, "D"));
        IOCaseTestCase.assertEquals((int)3, (int)IOCase.SENSITIVE.checkIndexOf("ABCDEFGHIJ", 3, "D"));
        IOCaseTestCase.assertEquals((int)-1, (int)IOCase.SENSITIVE.checkIndexOf("ABCDEFGHIJ", 4, "D"));
        IOCaseTestCase.assertEquals((int)3, (int)IOCase.SENSITIVE.checkIndexOf("ABCDEFGHIJ", 0, "DE"));
        IOCaseTestCase.assertEquals((int)3, (int)IOCase.SENSITIVE.checkIndexOf("ABCDEFGHIJ", 3, "DE"));
        IOCaseTestCase.assertEquals((int)-1, (int)IOCase.SENSITIVE.checkIndexOf("ABCDEFGHIJ", 4, "DE"));
        IOCaseTestCase.assertEquals((int)3, (int)IOCase.SENSITIVE.checkIndexOf("ABCDEFGHIJ", 0, "DEF"));
        IOCaseTestCase.assertEquals((int)3, (int)IOCase.SENSITIVE.checkIndexOf("ABCDEFGHIJ", 3, "DEF"));
        IOCaseTestCase.assertEquals((int)-1, (int)IOCase.SENSITIVE.checkIndexOf("ABCDEFGHIJ", 4, "DEF"));
        IOCaseTestCase.assertEquals((int)9, (int)IOCase.SENSITIVE.checkIndexOf("ABCDEFGHIJ", 0, "J"));
        IOCaseTestCase.assertEquals((int)9, (int)IOCase.SENSITIVE.checkIndexOf("ABCDEFGHIJ", 8, "J"));
        IOCaseTestCase.assertEquals((int)9, (int)IOCase.SENSITIVE.checkIndexOf("ABCDEFGHIJ", 9, "J"));
        IOCaseTestCase.assertEquals((int)8, (int)IOCase.SENSITIVE.checkIndexOf("ABCDEFGHIJ", 0, "IJ"));
        IOCaseTestCase.assertEquals((int)8, (int)IOCase.SENSITIVE.checkIndexOf("ABCDEFGHIJ", 8, "IJ"));
        IOCaseTestCase.assertEquals((int)-1, (int)IOCase.SENSITIVE.checkIndexOf("ABCDEFGHIJ", 9, "IJ"));
        IOCaseTestCase.assertEquals((int)7, (int)IOCase.SENSITIVE.checkIndexOf("ABCDEFGHIJ", 6, "HIJ"));
        IOCaseTestCase.assertEquals((int)7, (int)IOCase.SENSITIVE.checkIndexOf("ABCDEFGHIJ", 7, "HIJ"));
        IOCaseTestCase.assertEquals((int)-1, (int)IOCase.SENSITIVE.checkIndexOf("ABCDEFGHIJ", 8, "HIJ"));
        IOCaseTestCase.assertEquals((int)-1, (int)IOCase.SENSITIVE.checkIndexOf("ABCDEFGHIJ", 0, "DED"));
        IOCaseTestCase.assertEquals((int)-1, (int)IOCase.SENSITIVE.checkIndexOf("DEF", 0, "ABCDEFGHIJ"));
        try {
            IOCase.SENSITIVE.checkIndexOf("ABC", 0, null);
            IOCaseTestCase.fail();
        }
        catch (NullPointerException ex) {
            // empty catch block
        }
        try {
            IOCase.SENSITIVE.checkIndexOf(null, 0, "ABC");
            IOCaseTestCase.fail();
        }
        catch (NullPointerException ex) {
            // empty catch block
        }
        try {
            IOCase.SENSITIVE.checkIndexOf(null, 0, null);
            IOCaseTestCase.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void test_checkIndexOf_case() throws Exception {
        IOCaseTestCase.assertEquals((int)1, (int)IOCase.SENSITIVE.checkIndexOf("ABC", 0, "BC"));
        IOCaseTestCase.assertEquals((int)-1, (int)IOCase.SENSITIVE.checkIndexOf("ABC", 0, "Bc"));
        IOCaseTestCase.assertEquals((int)1, (int)IOCase.INSENSITIVE.checkIndexOf("ABC", 0, "BC"));
        IOCaseTestCase.assertEquals((int)1, (int)IOCase.INSENSITIVE.checkIndexOf("ABC", 0, "Bc"));
        IOCaseTestCase.assertEquals((int)1, (int)IOCase.SYSTEM.checkIndexOf("ABC", 0, "BC"));
        IOCaseTestCase.assertEquals((int)(WINDOWS ? 1 : -1), (int)IOCase.SYSTEM.checkIndexOf("ABC", 0, "Bc"));
    }

    public void test_checkRegionMatches_functionality() throws Exception {
        IOCaseTestCase.assertTrue((boolean)IOCase.SENSITIVE.checkRegionMatches("ABC", 0, ""));
        IOCaseTestCase.assertTrue((boolean)IOCase.SENSITIVE.checkRegionMatches("ABC", 0, "A"));
        IOCaseTestCase.assertTrue((boolean)IOCase.SENSITIVE.checkRegionMatches("ABC", 0, "AB"));
        IOCaseTestCase.assertTrue((boolean)IOCase.SENSITIVE.checkRegionMatches("ABC", 0, "ABC"));
        IOCaseTestCase.assertFalse((boolean)IOCase.SENSITIVE.checkRegionMatches("ABC", 0, "BC"));
        IOCaseTestCase.assertFalse((boolean)IOCase.SENSITIVE.checkRegionMatches("ABC", 0, "C"));
        IOCaseTestCase.assertFalse((boolean)IOCase.SENSITIVE.checkRegionMatches("ABC", 0, "ABCD"));
        IOCaseTestCase.assertFalse((boolean)IOCase.SENSITIVE.checkRegionMatches("", 0, "ABC"));
        IOCaseTestCase.assertTrue((boolean)IOCase.SENSITIVE.checkRegionMatches("", 0, ""));
        IOCaseTestCase.assertTrue((boolean)IOCase.SENSITIVE.checkRegionMatches("ABC", 1, ""));
        IOCaseTestCase.assertFalse((boolean)IOCase.SENSITIVE.checkRegionMatches("ABC", 1, "A"));
        IOCaseTestCase.assertFalse((boolean)IOCase.SENSITIVE.checkRegionMatches("ABC", 1, "AB"));
        IOCaseTestCase.assertFalse((boolean)IOCase.SENSITIVE.checkRegionMatches("ABC", 1, "ABC"));
        IOCaseTestCase.assertTrue((boolean)IOCase.SENSITIVE.checkRegionMatches("ABC", 1, "BC"));
        IOCaseTestCase.assertFalse((boolean)IOCase.SENSITIVE.checkRegionMatches("ABC", 1, "C"));
        IOCaseTestCase.assertFalse((boolean)IOCase.SENSITIVE.checkRegionMatches("ABC", 1, "ABCD"));
        IOCaseTestCase.assertFalse((boolean)IOCase.SENSITIVE.checkRegionMatches("", 1, "ABC"));
        IOCaseTestCase.assertFalse((boolean)IOCase.SENSITIVE.checkRegionMatches("", 1, ""));
        try {
            IOCase.SENSITIVE.checkRegionMatches("ABC", 0, null);
            IOCaseTestCase.fail();
        }
        catch (NullPointerException ex) {
            // empty catch block
        }
        try {
            IOCase.SENSITIVE.checkRegionMatches(null, 0, "ABC");
            IOCaseTestCase.fail();
        }
        catch (NullPointerException ex) {
            // empty catch block
        }
        try {
            IOCase.SENSITIVE.checkRegionMatches(null, 0, null);
            IOCaseTestCase.fail();
        }
        catch (NullPointerException ex) {
            // empty catch block
        }
        try {
            IOCase.SENSITIVE.checkRegionMatches("ABC", 1, null);
            IOCaseTestCase.fail();
        }
        catch (NullPointerException ex) {
            // empty catch block
        }
        try {
            IOCase.SENSITIVE.checkRegionMatches(null, 1, "ABC");
            IOCaseTestCase.fail();
        }
        catch (NullPointerException ex) {
            // empty catch block
        }
        try {
            IOCase.SENSITIVE.checkRegionMatches(null, 1, null);
            IOCaseTestCase.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void test_checkRegionMatches_case() throws Exception {
        IOCaseTestCase.assertTrue((boolean)IOCase.SENSITIVE.checkRegionMatches("ABC", 0, "AB"));
        IOCaseTestCase.assertFalse((boolean)IOCase.SENSITIVE.checkRegionMatches("ABC", 0, "Ab"));
        IOCaseTestCase.assertTrue((boolean)IOCase.INSENSITIVE.checkRegionMatches("ABC", 0, "AB"));
        IOCaseTestCase.assertTrue((boolean)IOCase.INSENSITIVE.checkRegionMatches("ABC", 0, "Ab"));
        IOCaseTestCase.assertTrue((boolean)IOCase.SYSTEM.checkRegionMatches("ABC", 0, "AB"));
        IOCaseTestCase.assertEquals((boolean)WINDOWS, (boolean)IOCase.SYSTEM.checkRegionMatches("ABC", 0, "Ab"));
    }

    private IOCase serialize(IOCase value) throws Exception {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(buf);
        out.writeObject(value);
        out.flush();
        out.close();
        ByteArrayInputStream bufin = new ByteArrayInputStream(buf.toByteArray());
        ObjectInputStream in = new ObjectInputStream(bufin);
        return (IOCase)in.readObject();
    }
}

