/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.io.testtools.FileBasedTestCase;
import org.apache.commons.io.testtools.YellOnFlushAndCloseOutputStream;

public class IOUtilsWriteTestCase
extends FileBasedTestCase {
    private static final int FILE_SIZE = 4097;
    private byte[] inData = this.generateTestData(4097L);

    public IOUtilsWriteTestCase(String testName) {
        super(testName);
    }

    public void setUp() throws Exception {
    }

    public void tearDown() throws Exception {
    }

    public void testWrite_byteArrayToOutputStream() throws Exception {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        YellOnFlushAndCloseOutputStream out = new YellOnFlushAndCloseOutputStream((OutputStream)baout, true, true);
        IOUtils.write((byte[])this.inData, (OutputStream)((Object)out));
        out.off();
        out.flush();
        IOUtilsWriteTestCase.assertEquals((String)"Sizes differ", (int)this.inData.length, (int)baout.size());
        IOUtilsWriteTestCase.assertTrue((String)"Content differs", (boolean)Arrays.equals(this.inData, baout.toByteArray()));
    }

    public void testWrite_byteArrayToOutputStream_nullData() throws Exception {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        YellOnFlushAndCloseOutputStream out = new YellOnFlushAndCloseOutputStream((OutputStream)baout, true, true);
        IOUtils.write((byte[])null, (OutputStream)((Object)out));
        out.off();
        out.flush();
        IOUtilsWriteTestCase.assertEquals((String)"Sizes differ", (int)0, (int)baout.size());
    }

    public void testWrite_byteArrayToOutputStream_nullStream() throws Exception {
        try {
            IOUtils.write((byte[])this.inData, (OutputStream)null);
            IOUtilsWriteTestCase.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testWrite_byteArrayToWriter() throws Exception {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        YellOnFlushAndCloseOutputStream out = new YellOnFlushAndCloseOutputStream((OutputStream)baout, true, true);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baout, "US-ASCII");
        IOUtils.write((byte[])this.inData, (Writer)writer);
        out.off();
        ((Writer)writer).flush();
        IOUtilsWriteTestCase.assertEquals((String)"Sizes differ", (int)this.inData.length, (int)baout.size());
        IOUtilsWriteTestCase.assertTrue((String)"Content differs", (boolean)Arrays.equals(this.inData, baout.toByteArray()));
    }

    public void testWrite_byteArrayToWriter_nullData() throws Exception {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        YellOnFlushAndCloseOutputStream out = new YellOnFlushAndCloseOutputStream((OutputStream)baout, true, true);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baout, "US-ASCII");
        IOUtils.write((byte[])null, (Writer)writer);
        out.off();
        ((Writer)writer).flush();
        IOUtilsWriteTestCase.assertEquals((String)"Sizes differ", (int)0, (int)baout.size());
    }

    public void testWrite_byteArrayToWriter_nullWriter() throws Exception {
        try {
            IOUtils.write((byte[])this.inData, (Writer)null);
            IOUtilsWriteTestCase.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testWrite_byteArrayToWriter_Encoding() throws Exception {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        YellOnFlushAndCloseOutputStream out = new YellOnFlushAndCloseOutputStream((OutputStream)baout, true, true);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baout, "US-ASCII");
        IOUtils.write((byte[])this.inData, (Writer)writer, (String)"UTF8");
        out.off();
        ((Writer)writer).flush();
        byte[] bytes = baout.toByteArray();
        bytes = new String(bytes, "UTF8").getBytes("US-ASCII");
        IOUtilsWriteTestCase.assertTrue((String)"Content differs", (boolean)Arrays.equals(this.inData, bytes));
    }

    public void testWrite_byteArrayToWriter_Encoding_nullData() throws Exception {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        YellOnFlushAndCloseOutputStream out = new YellOnFlushAndCloseOutputStream((OutputStream)baout, true, true);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baout, "US-ASCII");
        IOUtils.write((byte[])null, (Writer)writer, (String)"UTF8");
        out.off();
        ((Writer)writer).flush();
        IOUtilsWriteTestCase.assertEquals((String)"Sizes differ", (int)0, (int)baout.size());
    }

    public void testWrite_byteArrayToWriter_Encoding_nullWriter() throws Exception {
        try {
            IOUtils.write((byte[])this.inData, (Writer)null, (String)"UTF8");
            IOUtilsWriteTestCase.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testWrite_byteArrayToWriter_Encoding_nullEncoding() throws Exception {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        YellOnFlushAndCloseOutputStream out = new YellOnFlushAndCloseOutputStream((OutputStream)baout, true, true);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baout, "US-ASCII");
        IOUtils.write((byte[])this.inData, (Writer)writer, (String)null);
        out.off();
        ((Writer)writer).flush();
        IOUtilsWriteTestCase.assertEquals((String)"Sizes differ", (int)this.inData.length, (int)baout.size());
        IOUtilsWriteTestCase.assertTrue((String)"Content differs", (boolean)Arrays.equals(this.inData, baout.toByteArray()));
    }

    public void testWrite_charSequenceToOutputStream() throws Exception {
        StringBuilder csq = new StringBuilder(new String(this.inData, "US-ASCII"));
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        YellOnFlushAndCloseOutputStream out = new YellOnFlushAndCloseOutputStream((OutputStream)baout, true, true);
        IOUtils.write((CharSequence)csq, (OutputStream)((Object)out));
        out.off();
        out.flush();
        IOUtilsWriteTestCase.assertEquals((String)"Sizes differ", (int)this.inData.length, (int)baout.size());
        IOUtilsWriteTestCase.assertTrue((String)"Content differs", (boolean)Arrays.equals(this.inData, baout.toByteArray()));
    }

    public void testWrite_charSequenceToOutputStream_nullData() throws Exception {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        YellOnFlushAndCloseOutputStream out = new YellOnFlushAndCloseOutputStream((OutputStream)baout, true, true);
        IOUtils.write((CharSequence)null, (OutputStream)((Object)out));
        out.off();
        out.flush();
        IOUtilsWriteTestCase.assertEquals((String)"Sizes differ", (int)0, (int)baout.size());
    }

    public void testWrite_charSequenceToOutputStream_nullStream() throws Exception {
        StringBuilder csq = new StringBuilder(new String(this.inData, "US-ASCII"));
        try {
            IOUtils.write((CharSequence)csq, (OutputStream)null);
            IOUtilsWriteTestCase.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testWrite_charSequenceToOutputStream_Encoding() throws Exception {
        StringBuilder csq = new StringBuilder(new String(this.inData, "US-ASCII"));
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        YellOnFlushAndCloseOutputStream out = new YellOnFlushAndCloseOutputStream((OutputStream)baout, true, true);
        IOUtils.write((CharSequence)csq, (OutputStream)((Object)out), (String)"UTF16");
        out.off();
        out.flush();
        byte[] bytes = baout.toByteArray();
        bytes = new String(bytes, "UTF16").getBytes("US-ASCII");
        IOUtilsWriteTestCase.assertTrue((String)"Content differs", (boolean)Arrays.equals(this.inData, bytes));
    }

    public void testWrite_charSequenceToOutputStream_Encoding_nullData() throws Exception {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        YellOnFlushAndCloseOutputStream out = new YellOnFlushAndCloseOutputStream((OutputStream)baout, true, true);
        IOUtils.write((CharSequence)null, (OutputStream)((Object)out));
        out.off();
        out.flush();
        IOUtilsWriteTestCase.assertEquals((String)"Sizes differ", (int)0, (int)baout.size());
    }

    public void testWrite_charSequenceToOutputStream_Encoding_nullStream() throws Exception {
        StringBuilder csq = new StringBuilder(new String(this.inData, "US-ASCII"));
        try {
            IOUtils.write((CharSequence)csq, (OutputStream)null);
            IOUtilsWriteTestCase.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testWrite_charSequenceToOutputStream_nullEncoding() throws Exception {
        StringBuilder csq = new StringBuilder(new String(this.inData, "US-ASCII"));
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        YellOnFlushAndCloseOutputStream out = new YellOnFlushAndCloseOutputStream((OutputStream)baout, true, true);
        IOUtils.write((CharSequence)csq, (OutputStream)((Object)out), (String)null);
        out.off();
        out.flush();
        IOUtilsWriteTestCase.assertEquals((String)"Sizes differ", (int)this.inData.length, (int)baout.size());
        IOUtilsWriteTestCase.assertTrue((String)"Content differs", (boolean)Arrays.equals(this.inData, baout.toByteArray()));
    }

    public void testWrite_charSequenceToWriter() throws Exception {
        StringBuilder csq = new StringBuilder(new String(this.inData, "US-ASCII"));
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        YellOnFlushAndCloseOutputStream out = new YellOnFlushAndCloseOutputStream((OutputStream)baout, true, true);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baout, "US-ASCII");
        IOUtils.write((CharSequence)csq, (Writer)writer);
        out.off();
        ((Writer)writer).flush();
        IOUtilsWriteTestCase.assertEquals((String)"Sizes differ", (int)this.inData.length, (int)baout.size());
        IOUtilsWriteTestCase.assertTrue((String)"Content differs", (boolean)Arrays.equals(this.inData, baout.toByteArray()));
    }

    public void testWrite_charSequenceToWriter_Encoding_nullData() throws Exception {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        YellOnFlushAndCloseOutputStream out = new YellOnFlushAndCloseOutputStream((OutputStream)baout, true, true);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baout, "US-ASCII");
        IOUtils.write((CharSequence)null, (Writer)writer);
        out.off();
        ((Writer)writer).flush();
        IOUtilsWriteTestCase.assertEquals((String)"Sizes differ", (int)0, (int)baout.size());
    }

    public void testWrite_charSequenceToWriter_Encoding_nullStream() throws Exception {
        StringBuilder csq = new StringBuilder(new String(this.inData, "US-ASCII"));
        try {
            IOUtils.write((CharSequence)csq, (Writer)null);
            IOUtilsWriteTestCase.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testWrite_stringToOutputStream() throws Exception {
        String str = new String(this.inData, "US-ASCII");
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        YellOnFlushAndCloseOutputStream out = new YellOnFlushAndCloseOutputStream((OutputStream)baout, true, true);
        IOUtils.write((String)str, (OutputStream)((Object)out));
        out.off();
        out.flush();
        IOUtilsWriteTestCase.assertEquals((String)"Sizes differ", (int)this.inData.length, (int)baout.size());
        IOUtilsWriteTestCase.assertTrue((String)"Content differs", (boolean)Arrays.equals(this.inData, baout.toByteArray()));
    }

    public void testWrite_stringToOutputStream_nullData() throws Exception {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        YellOnFlushAndCloseOutputStream out = new YellOnFlushAndCloseOutputStream((OutputStream)baout, true, true);
        IOUtils.write((String)null, (OutputStream)((Object)out));
        out.off();
        out.flush();
        IOUtilsWriteTestCase.assertEquals((String)"Sizes differ", (int)0, (int)baout.size());
    }

    public void testWrite_stringToOutputStream_nullStream() throws Exception {
        String str = new String(this.inData, "US-ASCII");
        try {
            IOUtils.write((String)str, (OutputStream)null);
            IOUtilsWriteTestCase.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testWrite_stringToOutputStream_Encoding() throws Exception {
        String str = new String(this.inData, "US-ASCII");
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        YellOnFlushAndCloseOutputStream out = new YellOnFlushAndCloseOutputStream((OutputStream)baout, true, true);
        IOUtils.write((String)str, (OutputStream)((Object)out), (String)"UTF16");
        out.off();
        out.flush();
        byte[] bytes = baout.toByteArray();
        bytes = new String(bytes, "UTF16").getBytes("US-ASCII");
        IOUtilsWriteTestCase.assertTrue((String)"Content differs", (boolean)Arrays.equals(this.inData, bytes));
    }

    public void testWrite_stringToOutputStream_Encoding_nullData() throws Exception {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        YellOnFlushAndCloseOutputStream out = new YellOnFlushAndCloseOutputStream((OutputStream)baout, true, true);
        IOUtils.write((String)null, (OutputStream)((Object)out));
        out.off();
        out.flush();
        IOUtilsWriteTestCase.assertEquals((String)"Sizes differ", (int)0, (int)baout.size());
    }

    public void testWrite_stringToOutputStream_Encoding_nullStream() throws Exception {
        String str = new String(this.inData, "US-ASCII");
        try {
            IOUtils.write((String)str, (OutputStream)null);
            IOUtilsWriteTestCase.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testWrite_stringToOutputStream_nullEncoding() throws Exception {
        String str = new String(this.inData, "US-ASCII");
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        YellOnFlushAndCloseOutputStream out = new YellOnFlushAndCloseOutputStream((OutputStream)baout, true, true);
        IOUtils.write((String)str, (OutputStream)((Object)out), (String)null);
        out.off();
        out.flush();
        IOUtilsWriteTestCase.assertEquals((String)"Sizes differ", (int)this.inData.length, (int)baout.size());
        IOUtilsWriteTestCase.assertTrue((String)"Content differs", (boolean)Arrays.equals(this.inData, baout.toByteArray()));
    }

    public void testWrite_stringToWriter() throws Exception {
        String str = new String(this.inData, "US-ASCII");
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        YellOnFlushAndCloseOutputStream out = new YellOnFlushAndCloseOutputStream((OutputStream)baout, true, true);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baout, "US-ASCII");
        IOUtils.write((String)str, (Writer)writer);
        out.off();
        ((Writer)writer).flush();
        IOUtilsWriteTestCase.assertEquals((String)"Sizes differ", (int)this.inData.length, (int)baout.size());
        IOUtilsWriteTestCase.assertTrue((String)"Content differs", (boolean)Arrays.equals(this.inData, baout.toByteArray()));
    }

    public void testWrite_stringToWriter_Encoding_nullData() throws Exception {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        YellOnFlushAndCloseOutputStream out = new YellOnFlushAndCloseOutputStream((OutputStream)baout, true, true);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baout, "US-ASCII");
        IOUtils.write((String)null, (Writer)writer);
        out.off();
        ((Writer)writer).flush();
        IOUtilsWriteTestCase.assertEquals((String)"Sizes differ", (int)0, (int)baout.size());
    }

    public void testWrite_stringToWriter_Encoding_nullStream() throws Exception {
        String str = new String(this.inData, "US-ASCII");
        try {
            IOUtils.write((String)str, (Writer)null);
            IOUtilsWriteTestCase.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testWrite_charArrayToOutputStream() throws Exception {
        String str = new String(this.inData, "US-ASCII");
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        YellOnFlushAndCloseOutputStream out = new YellOnFlushAndCloseOutputStream((OutputStream)baout, true, true);
        IOUtils.write((char[])str.toCharArray(), (OutputStream)((Object)out));
        out.off();
        out.flush();
        IOUtilsWriteTestCase.assertEquals((String)"Sizes differ", (int)this.inData.length, (int)baout.size());
        IOUtilsWriteTestCase.assertTrue((String)"Content differs", (boolean)Arrays.equals(this.inData, baout.toByteArray()));
    }

    public void testWrite_charArrayToOutputStream_nullData() throws Exception {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        YellOnFlushAndCloseOutputStream out = new YellOnFlushAndCloseOutputStream((OutputStream)baout, true, true);
        IOUtils.write((char[])null, (OutputStream)((Object)out));
        out.off();
        out.flush();
        IOUtilsWriteTestCase.assertEquals((String)"Sizes differ", (int)0, (int)baout.size());
    }

    public void testWrite_charArrayToOutputStream_nullStream() throws Exception {
        String str = new String(this.inData, "US-ASCII");
        try {
            IOUtils.write((char[])str.toCharArray(), (OutputStream)null);
            IOUtilsWriteTestCase.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testWrite_charArrayToOutputStream_Encoding() throws Exception {
        String str = new String(this.inData, "US-ASCII");
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        YellOnFlushAndCloseOutputStream out = new YellOnFlushAndCloseOutputStream((OutputStream)baout, true, true);
        IOUtils.write((char[])str.toCharArray(), (OutputStream)((Object)out), (String)"UTF16");
        out.off();
        out.flush();
        byte[] bytes = baout.toByteArray();
        bytes = new String(bytes, "UTF16").getBytes("US-ASCII");
        IOUtilsWriteTestCase.assertTrue((String)"Content differs", (boolean)Arrays.equals(this.inData, bytes));
    }

    public void testWrite_charArrayToOutputStream_Encoding_nullData() throws Exception {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        YellOnFlushAndCloseOutputStream out = new YellOnFlushAndCloseOutputStream((OutputStream)baout, true, true);
        IOUtils.write((char[])null, (OutputStream)((Object)out));
        out.off();
        out.flush();
        IOUtilsWriteTestCase.assertEquals((String)"Sizes differ", (int)0, (int)baout.size());
    }

    public void testWrite_charArrayToOutputStream_Encoding_nullStream() throws Exception {
        String str = new String(this.inData, "US-ASCII");
        try {
            IOUtils.write((char[])str.toCharArray(), (OutputStream)null);
            IOUtilsWriteTestCase.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testWrite_charArrayToOutputStream_nullEncoding() throws Exception {
        String str = new String(this.inData, "US-ASCII");
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        YellOnFlushAndCloseOutputStream out = new YellOnFlushAndCloseOutputStream((OutputStream)baout, true, true);
        IOUtils.write((char[])str.toCharArray(), (OutputStream)((Object)out), (String)null);
        out.off();
        out.flush();
        IOUtilsWriteTestCase.assertEquals((String)"Sizes differ", (int)this.inData.length, (int)baout.size());
        IOUtilsWriteTestCase.assertTrue((String)"Content differs", (boolean)Arrays.equals(this.inData, baout.toByteArray()));
    }

    public void testWrite_charArrayToWriter() throws Exception {
        String str = new String(this.inData, "US-ASCII");
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        YellOnFlushAndCloseOutputStream out = new YellOnFlushAndCloseOutputStream((OutputStream)baout, true, true);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baout, "US-ASCII");
        IOUtils.write((char[])str.toCharArray(), (Writer)writer);
        out.off();
        ((Writer)writer).flush();
        IOUtilsWriteTestCase.assertEquals((String)"Sizes differ", (int)this.inData.length, (int)baout.size());
        IOUtilsWriteTestCase.assertTrue((String)"Content differs", (boolean)Arrays.equals(this.inData, baout.toByteArray()));
    }

    public void testWrite_charArrayToWriter_Encoding_nullData() throws Exception {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        YellOnFlushAndCloseOutputStream out = new YellOnFlushAndCloseOutputStream((OutputStream)baout, true, true);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baout, "US-ASCII");
        IOUtils.write((char[])null, (Writer)writer);
        out.off();
        ((Writer)writer).flush();
        IOUtilsWriteTestCase.assertEquals((String)"Sizes differ", (int)0, (int)baout.size());
    }

    public void testWrite_charArrayToWriter_Encoding_nullStream() throws Exception {
        String str = new String(this.inData, "US-ASCII");
        try {
            IOUtils.write((char[])str.toCharArray(), (Writer)null);
            IOUtilsWriteTestCase.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testWriteLines_OutputStream() throws Exception {
        Object[] data = new Object[]{"hello", new StringBuffer("world"), "", "this is", null, "some text"};
        List<Object> list = Arrays.asList(data);
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        YellOnFlushAndCloseOutputStream out = new YellOnFlushAndCloseOutputStream((OutputStream)baout, false, true);
        IOUtils.writeLines(list, (String)"*", (OutputStream)((Object)out));
        out.off();
        out.flush();
        String expected = "hello*world**this is**some text*";
        String actual = baout.toString();
        IOUtilsWriteTestCase.assertEquals((String)expected, (String)actual);
    }

    public void testWriteLines_OutputStream_nullData() throws Exception {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        YellOnFlushAndCloseOutputStream out = new YellOnFlushAndCloseOutputStream((OutputStream)baout, false, true);
        IOUtils.writeLines((Collection)null, (String)"*", (OutputStream)((Object)out));
        out.off();
        out.flush();
        IOUtilsWriteTestCase.assertEquals((String)"Sizes differ", (int)0, (int)baout.size());
    }

    public void testWriteLines_OutputStream_nullSeparator() throws Exception {
        Object[] data = new Object[]{"hello", "world"};
        List<Object> list = Arrays.asList(data);
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        YellOnFlushAndCloseOutputStream out = new YellOnFlushAndCloseOutputStream((OutputStream)baout, false, true);
        IOUtils.writeLines(list, (String)null, (OutputStream)((Object)out));
        out.off();
        out.flush();
        String expected = "hello" + IOUtils.LINE_SEPARATOR + "world" + IOUtils.LINE_SEPARATOR;
        String actual = baout.toString();
        IOUtilsWriteTestCase.assertEquals((String)expected, (String)actual);
    }

    public void testWriteLines_OutputStream_nullStream() throws Exception {
        Object[] data = new Object[]{"hello", "world"};
        List<Object> list = Arrays.asList(data);
        try {
            IOUtils.writeLines(list, (String)"*", (OutputStream)null);
            IOUtilsWriteTestCase.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testWriteLines_OutputStream_Encoding() throws Exception {
        Object[] data = new Object[]{"hello\u8364", new StringBuffer("world"), "", "this is", null, "some text"};
        List<Object> list = Arrays.asList(data);
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        YellOnFlushAndCloseOutputStream out = new YellOnFlushAndCloseOutputStream((OutputStream)baout, false, true);
        IOUtils.writeLines(list, (String)"*", (OutputStream)((Object)out), (String)"UTF-8");
        out.off();
        out.flush();
        String expected = "hello\u8364*world**this is**some text*";
        String actual = baout.toString("UTF-8");
        IOUtilsWriteTestCase.assertEquals((String)expected, (String)actual);
    }

    public void testWriteLines_OutputStream_Encoding_nullData() throws Exception {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        YellOnFlushAndCloseOutputStream out = new YellOnFlushAndCloseOutputStream((OutputStream)baout, false, true);
        IOUtils.writeLines((Collection)null, (String)"*", (OutputStream)((Object)out), (String)"US-ASCII");
        out.off();
        out.flush();
        IOUtilsWriteTestCase.assertEquals((String)"Sizes differ", (int)0, (int)baout.size());
    }

    public void testWriteLines_OutputStream_Encoding_nullSeparator() throws Exception {
        Object[] data = new Object[]{"hello", "world"};
        List<Object> list = Arrays.asList(data);
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        YellOnFlushAndCloseOutputStream out = new YellOnFlushAndCloseOutputStream((OutputStream)baout, false, true);
        IOUtils.writeLines(list, (String)null, (OutputStream)((Object)out), (String)"US-ASCII");
        out.off();
        out.flush();
        String expected = "hello" + IOUtils.LINE_SEPARATOR + "world" + IOUtils.LINE_SEPARATOR;
        String actual = baout.toString();
        IOUtilsWriteTestCase.assertEquals((String)expected, (String)actual);
    }

    public void testWriteLines_OutputStream_Encoding_nullStream() throws Exception {
        Object[] data = new Object[]{"hello", "world"};
        List<Object> list = Arrays.asList(data);
        try {
            IOUtils.writeLines(list, (String)"*", (OutputStream)null, (String)"US-ASCII");
            IOUtilsWriteTestCase.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testWriteLines_OutputStream_Encoding_nullEncoding() throws Exception {
        Object[] data = new Object[]{"hello", new StringBuffer("world"), "", "this is", null, "some text"};
        List<Object> list = Arrays.asList(data);
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        YellOnFlushAndCloseOutputStream out = new YellOnFlushAndCloseOutputStream((OutputStream)baout, false, true);
        IOUtils.writeLines(list, (String)"*", (OutputStream)((Object)out), (String)null);
        out.off();
        out.flush();
        String expected = "hello*world**this is**some text*";
        String actual = baout.toString();
        IOUtilsWriteTestCase.assertEquals((String)expected, (String)actual);
    }

    public void testWriteLines_Writer() throws Exception {
        Object[] data = new Object[]{"hello", new StringBuffer("world"), "", "this is", null, "some text"};
        List<Object> list = Arrays.asList(data);
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        YellOnFlushAndCloseOutputStream out = new YellOnFlushAndCloseOutputStream((OutputStream)baout, true, true);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baout, "US-ASCII");
        IOUtils.writeLines(list, (String)"*", (Writer)writer);
        out.off();
        ((Writer)writer).flush();
        String expected = "hello*world**this is**some text*";
        String actual = baout.toString();
        IOUtilsWriteTestCase.assertEquals((String)expected, (String)actual);
    }

    public void testWriteLines_Writer_nullData() throws Exception {
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        YellOnFlushAndCloseOutputStream out = new YellOnFlushAndCloseOutputStream((OutputStream)baout, true, true);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baout, "US-ASCII");
        IOUtils.writeLines((Collection)null, (String)"*", (Writer)writer);
        out.off();
        ((Writer)writer).flush();
        IOUtilsWriteTestCase.assertEquals((String)"Sizes differ", (int)0, (int)baout.size());
    }

    public void testWriteLines_Writer_nullSeparator() throws Exception {
        Object[] data = new Object[]{"hello", "world"};
        List<Object> list = Arrays.asList(data);
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        YellOnFlushAndCloseOutputStream out = new YellOnFlushAndCloseOutputStream((OutputStream)baout, true, true);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)baout, "US-ASCII");
        IOUtils.writeLines(list, (String)null, (Writer)writer);
        out.off();
        ((Writer)writer).flush();
        String expected = "hello" + IOUtils.LINE_SEPARATOR + "world" + IOUtils.LINE_SEPARATOR;
        String actual = baout.toString();
        IOUtilsWriteTestCase.assertEquals((String)expected, (String)actual);
    }

    public void testWriteLines_Writer_nullStream() throws Exception {
        Object[] data = new Object[]{"hello", "world"};
        List<Object> list = Arrays.asList(data);
        try {
            IOUtils.writeLines(list, (String)"*", (Writer)null);
            IOUtilsWriteTestCase.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }
}

