/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.filefilter;

import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.AndFileFilter;
import org.apache.commons.io.filefilter.CanReadFileFilter;
import org.apache.commons.io.filefilter.CanWriteFileFilter;
import org.apache.commons.io.filefilter.DelegateFileFilter;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.EmptyFileFilter;
import org.apache.commons.io.filefilter.FalseFileFilter;
import org.apache.commons.io.filefilter.FileFileFilter;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.HiddenFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.MagicNumberFileFilter;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.apache.commons.io.filefilter.NotFileFilter;
import org.apache.commons.io.filefilter.OrFileFilter;
import org.apache.commons.io.filefilter.PrefixFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.commons.io.filefilter.WildcardFilter;
import org.apache.commons.io.testtools.FileBasedTestCase;

public class FileFilterTestCase
extends FileBasedTestCase {
    static final String SVN_DIR_NAME = ".svn";
    private static final boolean WINDOWS = File.separatorChar == '\\';

    public FileFilterTestCase(String name) {
        super(name);
    }

    public void setUp() {
        FileFilterTestCase.getTestDirectory().mkdirs();
    }

    public void tearDown() throws Exception {
        FileUtils.deleteDirectory((File)FileFilterTestCase.getTestDirectory());
    }

    public void assertFiltering(IOFileFilter filter, File file, boolean expected) throws Exception {
        FileFilterTestCase.assertEquals((String)("Filter(File) " + filter.getClass().getName() + " not " + expected + " for " + file), (boolean)expected, (boolean)filter.accept(file));
        if (file != null && file.getParentFile() != null) {
            FileFilterTestCase.assertEquals((String)("Filter(File, String) " + filter.getClass().getName() + " not " + expected + " for " + file), (boolean)expected, (boolean)filter.accept(file.getParentFile(), file.getName()));
        } else if (file == null) {
            FileFilterTestCase.assertEquals((String)("Filter(File, String) " + filter.getClass().getName() + " not " + expected + " for null"), (boolean)expected, (boolean)filter.accept(file));
        }
        FileFilterTestCase.assertNotNull((Object)filter.toString());
    }

    public void testSuffix() throws Exception {
        SuffixFileFilter filter = new SuffixFileFilter(new String[]{"tes", "est"});
        File testFile = new File("test");
        File fredFile = new File("fred");
        this.assertFiltering((IOFileFilter)filter, new File("fred.tes"), true);
        this.assertFiltering((IOFileFilter)filter, new File("fred.est"), true);
        this.assertFiltering((IOFileFilter)filter, new File("fred.EST"), false);
        this.assertFiltering((IOFileFilter)filter, new File("fred.exe"), false);
        filter = FileFilterUtils.or((IOFileFilter[])new IOFileFilter[]{FileFilterUtils.suffixFileFilter((String)"tes"), FileFilterUtils.suffixFileFilter((String)"est")});
        this.assertFiltering((IOFileFilter)filter, new File("fred"), false);
        this.assertFiltering((IOFileFilter)filter, new File(".tes"), true);
        this.assertFiltering((IOFileFilter)filter, new File("fred.test"), true);
        filter = new SuffixFileFilter("est");
        this.assertFiltering((IOFileFilter)filter, new File("test"), true);
        this.assertFiltering((IOFileFilter)filter, new File("fred"), false);
        FileFilterTestCase.assertTrue((boolean)filter.accept(testFile.getParentFile(), testFile.getName()));
        FileFilterTestCase.assertTrue((!filter.accept(fredFile.getParentFile(), fredFile.getName()) ? 1 : 0) != 0);
        List<String> prefixes = Arrays.asList("ood", "red");
        SuffixFileFilter listFilter = new SuffixFileFilter(prefixes);
        FileFilterTestCase.assertTrue((!listFilter.accept(testFile.getParentFile(), testFile.getName()) ? 1 : 0) != 0);
        FileFilterTestCase.assertTrue((boolean)listFilter.accept(fredFile.getParentFile(), fredFile.getName()));
        try {
            new SuffixFileFilter((String)null);
            FileFilterTestCase.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            new SuffixFileFilter((String[])null);
            FileFilterTestCase.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            new SuffixFileFilter((List)null);
            FileFilterTestCase.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
    }

    public void testSuffixCaseInsensitive() throws Exception {
        SuffixFileFilter filter = new SuffixFileFilter(new String[]{"tes", "est"}, IOCase.INSENSITIVE);
        this.assertFiltering((IOFileFilter)filter, new File("foo.tes"), true);
        this.assertFiltering((IOFileFilter)filter, new File("foo.est"), true);
        this.assertFiltering((IOFileFilter)filter, new File("foo.EST"), true);
        this.assertFiltering((IOFileFilter)filter, new File("foo.TES"), true);
        this.assertFiltering((IOFileFilter)filter, new File("foo.exe"), false);
        filter = new SuffixFileFilter("est", IOCase.INSENSITIVE);
        this.assertFiltering((IOFileFilter)filter, new File("test"), true);
        this.assertFiltering((IOFileFilter)filter, new File("TEST"), true);
        List<String> suffixes = Arrays.asList("tes", "est");
        filter = new SuffixFileFilter(suffixes, IOCase.INSENSITIVE);
        this.assertFiltering((IOFileFilter)filter, new File("bar.tes"), true);
        this.assertFiltering((IOFileFilter)filter, new File("bar.est"), true);
        this.assertFiltering((IOFileFilter)filter, new File("bar.EST"), true);
        this.assertFiltering((IOFileFilter)filter, new File("bar.TES"), true);
        this.assertFiltering((IOFileFilter)filter, new File("bar.exe"), false);
        try {
            new SuffixFileFilter((String)null, IOCase.INSENSITIVE);
            FileFilterTestCase.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            new SuffixFileFilter((String[])null, IOCase.INSENSITIVE);
            FileFilterTestCase.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            new SuffixFileFilter((List)null, IOCase.INSENSITIVE);
            FileFilterTestCase.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        filter = FileFilterUtils.suffixFileFilter((String)"est", (IOCase)IOCase.INSENSITIVE);
        this.assertFiltering((IOFileFilter)filter, new File("test"), true);
        this.assertFiltering((IOFileFilter)filter, new File("TEST"), true);
        try {
            FileFilterUtils.suffixFileFilter((String)null, (IOCase)IOCase.INSENSITIVE);
            FileFilterTestCase.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testDirectory() throws Exception {
        DirectoryFileFilter filter = new DirectoryFileFilter();
        this.assertFiltering((IOFileFilter)filter, new File("src/"), true);
        this.assertFiltering((IOFileFilter)filter, new File("src/main/java/"), true);
        this.assertFiltering((IOFileFilter)filter, new File("pom.xml"), false);
        this.assertFiltering((IOFileFilter)filter, new File("imaginary"), false);
        this.assertFiltering((IOFileFilter)filter, new File("imaginary/"), false);
        this.assertFiltering((IOFileFilter)filter, new File("LICENSE.txt"), false);
        FileFilterTestCase.assertSame((Object)DirectoryFileFilter.DIRECTORY, (Object)DirectoryFileFilter.INSTANCE);
    }

    public void testFiles() throws Exception {
        IOFileFilter filter = FileFileFilter.FILE;
        this.assertFiltering(filter, new File("src/"), false);
        this.assertFiltering(filter, new File("src/java/"), false);
        this.assertFiltering(filter, new File("pom.xml"), true);
        this.assertFiltering(filter, new File("imaginary"), false);
        this.assertFiltering(filter, new File("imaginary/"), false);
        this.assertFiltering(filter, new File("LICENSE.txt"), true);
    }

    public void testPrefix() throws Exception {
        PrefixFileFilter filter = new PrefixFileFilter(new String[]{"foo", "bar"});
        File testFile = new File("test");
        File fredFile = new File("fred");
        this.assertFiltering((IOFileFilter)filter, new File("foo.test"), true);
        this.assertFiltering((IOFileFilter)filter, new File("FOO.test"), false);
        this.assertFiltering((IOFileFilter)filter, new File("foo"), true);
        this.assertFiltering((IOFileFilter)filter, new File("bar"), true);
        this.assertFiltering((IOFileFilter)filter, new File("food/"), true);
        filter = FileFilterUtils.prefixFileFilter((String)"bar");
        this.assertFiltering((IOFileFilter)filter, new File("barred\\"), true);
        this.assertFiltering((IOFileFilter)filter, new File("test"), false);
        this.assertFiltering((IOFileFilter)filter, new File("fo_o.test"), false);
        this.assertFiltering((IOFileFilter)filter, new File("abar.exe"), false);
        filter = new PrefixFileFilter("tes");
        this.assertFiltering((IOFileFilter)filter, new File("test"), true);
        this.assertFiltering((IOFileFilter)filter, new File("fred"), false);
        FileFilterTestCase.assertTrue((boolean)filter.accept(testFile.getParentFile(), testFile.getName()));
        FileFilterTestCase.assertTrue((!filter.accept(fredFile.getParentFile(), fredFile.getName()) ? 1 : 0) != 0);
        List<String> prefixes = Arrays.asList("foo", "fre");
        PrefixFileFilter listFilter = new PrefixFileFilter(prefixes);
        FileFilterTestCase.assertTrue((!listFilter.accept(testFile.getParentFile(), testFile.getName()) ? 1 : 0) != 0);
        FileFilterTestCase.assertTrue((boolean)listFilter.accept(fredFile.getParentFile(), fredFile.getName()));
        try {
            new PrefixFileFilter((String)null);
            FileFilterTestCase.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            new PrefixFileFilter((String[])null);
            FileFilterTestCase.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            new PrefixFileFilter((List)null);
            FileFilterTestCase.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
    }

    public void testPrefixCaseInsensitive() throws Exception {
        PrefixFileFilter filter = new PrefixFileFilter(new String[]{"foo", "bar"}, IOCase.INSENSITIVE);
        this.assertFiltering((IOFileFilter)filter, new File("foo.test1"), true);
        this.assertFiltering((IOFileFilter)filter, new File("bar.test1"), true);
        this.assertFiltering((IOFileFilter)filter, new File("FOO.test1"), true);
        this.assertFiltering((IOFileFilter)filter, new File("BAR.test1"), true);
        filter = new PrefixFileFilter("bar", IOCase.INSENSITIVE);
        this.assertFiltering((IOFileFilter)filter, new File("foo.test2"), false);
        this.assertFiltering((IOFileFilter)filter, new File("bar.test2"), true);
        this.assertFiltering((IOFileFilter)filter, new File("FOO.test2"), false);
        this.assertFiltering((IOFileFilter)filter, new File("BAR.test2"), true);
        List<String> prefixes = Arrays.asList("foo", "bar");
        filter = new PrefixFileFilter(prefixes, IOCase.INSENSITIVE);
        this.assertFiltering((IOFileFilter)filter, new File("foo.test3"), true);
        this.assertFiltering((IOFileFilter)filter, new File("bar.test3"), true);
        this.assertFiltering((IOFileFilter)filter, new File("FOO.test3"), true);
        this.assertFiltering((IOFileFilter)filter, new File("BAR.test3"), true);
        try {
            new PrefixFileFilter((String)null, IOCase.INSENSITIVE);
            FileFilterTestCase.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            new PrefixFileFilter((String[])null, IOCase.INSENSITIVE);
            FileFilterTestCase.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            new PrefixFileFilter((List)null, IOCase.INSENSITIVE);
            FileFilterTestCase.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        filter = FileFilterUtils.prefixFileFilter((String)"bar", (IOCase)IOCase.INSENSITIVE);
        this.assertFiltering((IOFileFilter)filter, new File("foo.test2"), false);
        this.assertFiltering((IOFileFilter)filter, new File("bar.test2"), true);
        this.assertFiltering((IOFileFilter)filter, new File("FOO.test2"), false);
        this.assertFiltering((IOFileFilter)filter, new File("BAR.test2"), true);
        try {
            FileFilterUtils.prefixFileFilter((String)null, (IOCase)IOCase.INSENSITIVE);
            FileFilterTestCase.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testNameFilter() throws Exception {
        NameFileFilter filter = new NameFileFilter(new String[]{"foo", "bar"});
        this.assertFiltering((IOFileFilter)filter, new File("foo"), true);
        this.assertFiltering((IOFileFilter)filter, new File("bar"), true);
        this.assertFiltering((IOFileFilter)filter, new File("fred"), false);
        filter = new NameFileFilter(new String[]{"foo", "bar"}, IOCase.SENSITIVE);
        this.assertFiltering((IOFileFilter)filter, new File("foo"), true);
        this.assertFiltering((IOFileFilter)filter, new File("bar"), true);
        this.assertFiltering((IOFileFilter)filter, new File("FOO"), false);
        this.assertFiltering((IOFileFilter)filter, new File("BAR"), false);
        filter = new NameFileFilter(new String[]{"foo", "bar"}, IOCase.INSENSITIVE);
        this.assertFiltering((IOFileFilter)filter, new File("foo"), true);
        this.assertFiltering((IOFileFilter)filter, new File("bar"), true);
        this.assertFiltering((IOFileFilter)filter, new File("FOO"), true);
        this.assertFiltering((IOFileFilter)filter, new File("BAR"), true);
        filter = new NameFileFilter(new String[]{"foo", "bar"}, IOCase.SYSTEM);
        this.assertFiltering((IOFileFilter)filter, new File("foo"), true);
        this.assertFiltering((IOFileFilter)filter, new File("bar"), true);
        this.assertFiltering((IOFileFilter)filter, new File("FOO"), WINDOWS);
        this.assertFiltering((IOFileFilter)filter, new File("BAR"), WINDOWS);
        filter = new NameFileFilter(new String[]{"foo", "bar"}, (IOCase)null);
        this.assertFiltering((IOFileFilter)filter, new File("foo"), true);
        this.assertFiltering((IOFileFilter)filter, new File("bar"), true);
        this.assertFiltering((IOFileFilter)filter, new File("FOO"), false);
        this.assertFiltering((IOFileFilter)filter, new File("BAR"), false);
        ArrayList<String> list = new ArrayList<String>();
        list.add("foo");
        list.add("bar");
        filter = new NameFileFilter(list);
        this.assertFiltering((IOFileFilter)filter, new File("foo"), true);
        this.assertFiltering((IOFileFilter)filter, new File("bar"), true);
        this.assertFiltering((IOFileFilter)filter, new File("fred"), false);
        filter = new NameFileFilter("foo");
        this.assertFiltering((IOFileFilter)filter, new File("foo"), true);
        this.assertFiltering((IOFileFilter)filter, new File("FOO"), false);
        this.assertFiltering((IOFileFilter)filter, new File("barfoo"), false);
        this.assertFiltering((IOFileFilter)filter, new File("foobar"), false);
        this.assertFiltering((IOFileFilter)filter, new File("fred"), false);
        filter = FileFilterUtils.nameFileFilter((String)"foo", (IOCase)IOCase.INSENSITIVE);
        this.assertFiltering((IOFileFilter)filter, new File("foo"), true);
        this.assertFiltering((IOFileFilter)filter, new File("FOO"), true);
        this.assertFiltering((IOFileFilter)filter, new File("barfoo"), false);
        this.assertFiltering((IOFileFilter)filter, new File("foobar"), false);
        this.assertFiltering((IOFileFilter)filter, new File("fred"), false);
    }

    public void testNameFilterNullArgument() throws Exception {
        String test = null;
        try {
            new NameFileFilter(test);
            FileFilterTestCase.fail((String)"constructing a NameFileFilter with a null String argument should fail.");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            FileFilterUtils.nameFileFilter(test, (IOCase)IOCase.INSENSITIVE);
            FileFilterTestCase.fail((String)"constructing a NameFileFilter with a null String argument should fail.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testNameFilterNullArrayArgument() throws Exception {
        String[] test = null;
        try {
            new NameFileFilter(test);
            FileFilterTestCase.fail((String)"constructing a NameFileFilter with a null String[] argument should fail.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testNameFilterNullListArgument() throws Exception {
        List test = null;
        try {
            new NameFileFilter(test);
            FileFilterTestCase.fail((String)"constructing a NameFileFilter with a null List argument should fail.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testTrue() throws Exception {
        IOFileFilter filter = FileFilterUtils.trueFileFilter();
        this.assertFiltering(filter, new File("foo.test"), true);
        this.assertFiltering(filter, new File("foo"), true);
        this.assertFiltering(filter, null, true);
        FileFilterTestCase.assertSame((Object)TrueFileFilter.TRUE, (Object)TrueFileFilter.INSTANCE);
    }

    public void testFalse() throws Exception {
        IOFileFilter filter = FileFilterUtils.falseFileFilter();
        this.assertFiltering(filter, new File("foo.test"), false);
        this.assertFiltering(filter, new File("foo"), false);
        this.assertFiltering(filter, null, false);
        FileFilterTestCase.assertSame((Object)FalseFileFilter.FALSE, (Object)FalseFileFilter.INSTANCE);
    }

    public void testNot() throws Exception {
        IOFileFilter filter = FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.trueFileFilter());
        this.assertFiltering(filter, new File("foo.test"), false);
        this.assertFiltering(filter, new File("foo"), false);
        this.assertFiltering(filter, null, false);
        try {
            new NotFileFilter(null);
            FileFilterTestCase.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testAnd() throws Exception {
        IOFileFilter trueFilter = TrueFileFilter.INSTANCE;
        IOFileFilter falseFilter = FalseFileFilter.INSTANCE;
        this.assertFiltering((IOFileFilter)new AndFileFilter(trueFilter, trueFilter), new File("foo.test"), true);
        this.assertFiltering((IOFileFilter)new AndFileFilter(trueFilter, falseFilter), new File("foo.test"), false);
        this.assertFiltering((IOFileFilter)new AndFileFilter(falseFilter, trueFilter), new File("foo.test"), false);
        this.assertFiltering((IOFileFilter)new AndFileFilter(falseFilter, falseFilter), new File("foo.test"), false);
        ArrayList filters = new ArrayList();
        this.assertFiltering((IOFileFilter)new AndFileFilter(filters), new File("test"), false);
        this.assertFiltering((IOFileFilter)new AndFileFilter(), new File("test"), false);
        try {
            new AndFileFilter(falseFilter, null);
            FileFilterTestCase.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            new AndFileFilter(null, falseFilter);
            FileFilterTestCase.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        AndFileFilter f = new AndFileFilter((List)null);
        FileFilterTestCase.assertTrue((boolean)f.getFileFilters().isEmpty());
        FileFilterTestCase.assertNotNull((Object)f.toString());
    }

    public void testOr() throws Exception {
        IOFileFilter trueFilter = TrueFileFilter.INSTANCE;
        IOFileFilter falseFilter = FalseFileFilter.INSTANCE;
        File testFile = new File("foo.test");
        this.assertFiltering((IOFileFilter)new OrFileFilter(trueFilter, trueFilter), testFile, true);
        this.assertFiltering((IOFileFilter)new OrFileFilter(trueFilter, falseFilter), testFile, true);
        this.assertFiltering((IOFileFilter)new OrFileFilter(falseFilter, trueFilter), testFile, true);
        this.assertFiltering((IOFileFilter)new OrFileFilter(falseFilter, falseFilter), testFile, false);
        this.assertFiltering((IOFileFilter)new OrFileFilter(), testFile, false);
        ArrayList<IOFileFilter> filters = new ArrayList<IOFileFilter>();
        filters.add(trueFilter);
        filters.add(falseFilter);
        OrFileFilter orFilter = new OrFileFilter(filters);
        this.assertFiltering((IOFileFilter)orFilter, testFile, true);
        FileFilterTestCase.assertEquals((Object)orFilter.getFileFilters(), filters);
        orFilter.removeFileFilter(trueFilter);
        this.assertFiltering((IOFileFilter)orFilter, testFile, false);
        orFilter.setFileFilters(filters);
        this.assertFiltering((IOFileFilter)orFilter, testFile, true);
        FileFilterTestCase.assertTrue((boolean)orFilter.accept(testFile.getParentFile(), testFile.getName()));
        orFilter.removeFileFilter(trueFilter);
        FileFilterTestCase.assertTrue((!orFilter.accept(testFile.getParentFile(), testFile.getName()) ? 1 : 0) != 0);
        try {
            new OrFileFilter(falseFilter, null);
            FileFilterTestCase.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        OrFileFilter f = new OrFileFilter((List)null);
        FileFilterTestCase.assertTrue((boolean)f.getFileFilters().isEmpty());
    }

    public void testFileFilterUtils_and() throws Exception {
        IOFileFilter trueFilter = TrueFileFilter.INSTANCE;
        IOFileFilter falseFilter = FalseFileFilter.INSTANCE;
        this.assertFiltering(FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{trueFilter, trueFilter, trueFilter}), new File("foo.test"), true);
        this.assertFiltering(FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{trueFilter, falseFilter, trueFilter}), new File("foo.test"), false);
        this.assertFiltering(FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{falseFilter, trueFilter}), new File("foo.test"), false);
        this.assertFiltering(FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{falseFilter, falseFilter}), new File("foo.test"), false);
    }

    public void testFileFilterUtils_or() throws Exception {
        IOFileFilter trueFilter = TrueFileFilter.INSTANCE;
        IOFileFilter falseFilter = FalseFileFilter.INSTANCE;
        File testFile = new File("foo.test");
        this.assertFiltering(FileFilterUtils.or((IOFileFilter[])new IOFileFilter[]{trueFilter, trueFilter}), testFile, true);
        this.assertFiltering(FileFilterUtils.or((IOFileFilter[])new IOFileFilter[]{trueFilter, trueFilter, falseFilter}), testFile, true);
        this.assertFiltering(FileFilterUtils.or((IOFileFilter[])new IOFileFilter[]{falseFilter, trueFilter}), testFile, true);
        this.assertFiltering(FileFilterUtils.or((IOFileFilter[])new IOFileFilter[]{falseFilter, falseFilter, falseFilter}), testFile, false);
    }

    public void testDeprecatedWildcard() throws Exception {
        WildcardFilter filter = new WildcardFilter("*.txt");
        List<String> patternList = Arrays.asList("*.txt", "*.xml", "*.gif");
        WildcardFilter listFilter = new WildcardFilter(patternList);
        File txtFile = new File("test.txt");
        File bmpFile = new File("test.bmp");
        File dir = new File("src/java");
        this.assertFiltering((IOFileFilter)filter, new File("log.txt"), true);
        filter = new WildcardFilter("log?.txt");
        this.assertFiltering((IOFileFilter)filter, new File("log1.txt"), true);
        this.assertFiltering((IOFileFilter)filter, new File("log12.txt"), false);
        filter = new WildcardFilter("open??.????04");
        this.assertFiltering((IOFileFilter)filter, new File("openAB.102504"), true);
        this.assertFiltering((IOFileFilter)filter, new File("openA.102504"), false);
        this.assertFiltering((IOFileFilter)filter, new File("openXY.123103"), false);
        filter = new WildcardFilter(new String[]{"*.java", "*.class"});
        this.assertFiltering((IOFileFilter)filter, new File("Test.java"), true);
        this.assertFiltering((IOFileFilter)filter, new File("Test.class"), true);
        this.assertFiltering((IOFileFilter)filter, new File("Test.jsp"), false);
        this.assertFiltering((IOFileFilter)listFilter, new File("Test.txt"), true);
        this.assertFiltering((IOFileFilter)listFilter, new File("Test.xml"), true);
        this.assertFiltering((IOFileFilter)listFilter, new File("Test.gif"), true);
        this.assertFiltering((IOFileFilter)listFilter, new File("Test.bmp"), false);
        FileFilterTestCase.assertTrue((boolean)listFilter.accept(txtFile));
        FileFilterTestCase.assertTrue((!listFilter.accept(bmpFile) ? 1 : 0) != 0);
        FileFilterTestCase.assertTrue((!listFilter.accept(dir) ? 1 : 0) != 0);
        FileFilterTestCase.assertTrue((boolean)listFilter.accept(txtFile.getParentFile(), txtFile.getName()));
        FileFilterTestCase.assertTrue((!listFilter.accept(bmpFile.getParentFile(), bmpFile.getName()) ? 1 : 0) != 0);
        FileFilterTestCase.assertTrue((!listFilter.accept(dir.getParentFile(), dir.getName()) ? 1 : 0) != 0);
        try {
            new WildcardFilter((String)null);
            FileFilterTestCase.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            new WildcardFilter((String[])null);
            FileFilterTestCase.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            new WildcardFilter((List)null);
            FileFilterTestCase.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
    }

    public void testWildcard() throws Exception {
        WildcardFileFilter filter = new WildcardFileFilter("*.txt");
        this.assertFiltering((IOFileFilter)filter, new File("log.txt"), true);
        this.assertFiltering((IOFileFilter)filter, new File("log.TXT"), false);
        filter = new WildcardFileFilter("*.txt", IOCase.SENSITIVE);
        this.assertFiltering((IOFileFilter)filter, new File("log.txt"), true);
        this.assertFiltering((IOFileFilter)filter, new File("log.TXT"), false);
        filter = new WildcardFileFilter("*.txt", IOCase.INSENSITIVE);
        this.assertFiltering((IOFileFilter)filter, new File("log.txt"), true);
        this.assertFiltering((IOFileFilter)filter, new File("log.TXT"), true);
        filter = new WildcardFileFilter("*.txt", IOCase.SYSTEM);
        this.assertFiltering((IOFileFilter)filter, new File("log.txt"), true);
        this.assertFiltering((IOFileFilter)filter, new File("log.TXT"), WINDOWS);
        filter = new WildcardFileFilter("*.txt", (IOCase)null);
        this.assertFiltering((IOFileFilter)filter, new File("log.txt"), true);
        this.assertFiltering((IOFileFilter)filter, new File("log.TXT"), false);
        filter = new WildcardFileFilter(new String[]{"*.java", "*.class"});
        this.assertFiltering((IOFileFilter)filter, new File("Test.java"), true);
        this.assertFiltering((IOFileFilter)filter, new File("Test.class"), true);
        this.assertFiltering((IOFileFilter)filter, new File("Test.jsp"), false);
        filter = new WildcardFileFilter(new String[]{"*.java", "*.class"}, IOCase.SENSITIVE);
        this.assertFiltering((IOFileFilter)filter, new File("Test.java"), true);
        this.assertFiltering((IOFileFilter)filter, new File("Test.JAVA"), false);
        filter = new WildcardFileFilter(new String[]{"*.java", "*.class"}, IOCase.INSENSITIVE);
        this.assertFiltering((IOFileFilter)filter, new File("Test.java"), true);
        this.assertFiltering((IOFileFilter)filter, new File("Test.JAVA"), true);
        filter = new WildcardFileFilter(new String[]{"*.java", "*.class"}, IOCase.SYSTEM);
        this.assertFiltering((IOFileFilter)filter, new File("Test.java"), true);
        this.assertFiltering((IOFileFilter)filter, new File("Test.JAVA"), WINDOWS);
        filter = new WildcardFileFilter(new String[]{"*.java", "*.class"}, (IOCase)null);
        this.assertFiltering((IOFileFilter)filter, new File("Test.java"), true);
        this.assertFiltering((IOFileFilter)filter, new File("Test.JAVA"), false);
        List<String> patternList = Arrays.asList("*.txt", "*.xml", "*.gif");
        WildcardFileFilter listFilter = new WildcardFileFilter(patternList);
        this.assertFiltering((IOFileFilter)listFilter, new File("Test.txt"), true);
        this.assertFiltering((IOFileFilter)listFilter, new File("Test.xml"), true);
        this.assertFiltering((IOFileFilter)listFilter, new File("Test.gif"), true);
        this.assertFiltering((IOFileFilter)listFilter, new File("Test.bmp"), false);
        File txtFile = new File("test.txt");
        File bmpFile = new File("test.bmp");
        File dir = new File("src/java");
        FileFilterTestCase.assertTrue((boolean)listFilter.accept(txtFile));
        FileFilterTestCase.assertTrue((!listFilter.accept(bmpFile) ? 1 : 0) != 0);
        FileFilterTestCase.assertTrue((!listFilter.accept(dir) ? 1 : 0) != 0);
        FileFilterTestCase.assertTrue((boolean)listFilter.accept(txtFile.getParentFile(), txtFile.getName()));
        FileFilterTestCase.assertTrue((!listFilter.accept(bmpFile.getParentFile(), bmpFile.getName()) ? 1 : 0) != 0);
        FileFilterTestCase.assertTrue((!listFilter.accept(dir.getParentFile(), dir.getName()) ? 1 : 0) != 0);
        try {
            new WildcardFileFilter((String)null);
            FileFilterTestCase.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            new WildcardFileFilter((String[])null);
            FileFilterTestCase.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            new WildcardFileFilter((List)null);
            FileFilterTestCase.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
    }

    public void testDelegateFileFilter() throws Exception {
        OrFileFilter orFilter = new OrFileFilter();
        File testFile = new File("test.txt");
        DelegateFileFilter filter = new DelegateFileFilter((FileFilter)orFilter);
        this.assertFiltering((IOFileFilter)filter, testFile, false);
        FileFilterTestCase.assertNotNull((Object)filter.toString());
        filter = new DelegateFileFilter((FilenameFilter)orFilter);
        this.assertFiltering((IOFileFilter)filter, testFile, false);
        FileFilterTestCase.assertNotNull((Object)filter.toString());
        try {
            new DelegateFileFilter((FileFilter)null);
            FileFilterTestCase.fail();
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            new DelegateFileFilter((FilenameFilter)null);
            FileFilterTestCase.fail();
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
    }

    public void testMakeCVSAware() throws Exception {
        IOFileFilter filter1 = FileFilterUtils.makeCVSAware(null);
        IOFileFilter filter2 = FileFilterUtils.makeCVSAware((IOFileFilter)FileFilterUtils.nameFileFilter((String)"test-file1.txt"));
        File file = new File(FileFilterTestCase.getTestDirectory(), "CVS");
        file.mkdirs();
        this.assertFiltering(filter1, file, false);
        this.assertFiltering(filter2, file, false);
        FileUtils.deleteDirectory((File)file);
        file = new File(FileFilterTestCase.getTestDirectory(), "test-file1.txt");
        this.createFile(file, 0L);
        this.assertFiltering(filter1, file, true);
        this.assertFiltering(filter2, file, true);
        file = new File(FileFilterTestCase.getTestDirectory(), "test-file2.log");
        this.createFile(file, 0L);
        this.assertFiltering(filter1, file, true);
        this.assertFiltering(filter2, file, false);
        file = new File(FileFilterTestCase.getTestDirectory(), "CVS");
        this.createFile(file, 0L);
        this.assertFiltering(filter1, file, true);
        this.assertFiltering(filter2, file, false);
    }

    public void testMakeSVNAware() throws Exception {
        IOFileFilter filter1 = FileFilterUtils.makeSVNAware(null);
        IOFileFilter filter2 = FileFilterUtils.makeSVNAware((IOFileFilter)FileFilterUtils.nameFileFilter((String)"test-file1.txt"));
        File file = new File(FileFilterTestCase.getTestDirectory(), SVN_DIR_NAME);
        file.mkdirs();
        this.assertFiltering(filter1, file, false);
        this.assertFiltering(filter2, file, false);
        FileUtils.deleteDirectory((File)file);
        file = new File(FileFilterTestCase.getTestDirectory(), "test-file1.txt");
        this.createFile(file, 0L);
        this.assertFiltering(filter1, file, true);
        this.assertFiltering(filter2, file, true);
        file = new File(FileFilterTestCase.getTestDirectory(), "test-file2.log");
        this.createFile(file, 0L);
        this.assertFiltering(filter1, file, true);
        this.assertFiltering(filter2, file, false);
        file = new File(FileFilterTestCase.getTestDirectory(), SVN_DIR_NAME);
        this.createFile(file, 0L);
        this.assertFiltering(filter1, file, true);
        this.assertFiltering(filter2, file, false);
    }

    public void testAgeFilter() throws Exception {
        File oldFile = new File(FileFilterTestCase.getTestDirectory(), "old.txt");
        File reference = new File(FileFilterTestCase.getTestDirectory(), "reference.txt");
        File newFile = new File(FileFilterTestCase.getTestDirectory(), "new.txt");
        this.createFile(oldFile, 0L);
        do {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            this.createFile(reference, 0L);
        } while (oldFile.lastModified() == reference.lastModified());
        Date date = new Date();
        long now = date.getTime();
        do {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            this.createFile(newFile, 0L);
        } while (reference.lastModified() == newFile.lastModified());
        IOFileFilter filter1 = FileFilterUtils.ageFileFilter((long)now);
        IOFileFilter filter2 = FileFilterUtils.ageFileFilter((long)now, (boolean)true);
        IOFileFilter filter3 = FileFilterUtils.ageFileFilter((long)now, (boolean)false);
        IOFileFilter filter4 = FileFilterUtils.ageFileFilter((Date)date);
        IOFileFilter filter5 = FileFilterUtils.ageFileFilter((Date)date, (boolean)true);
        IOFileFilter filter6 = FileFilterUtils.ageFileFilter((Date)date, (boolean)false);
        IOFileFilter filter7 = FileFilterUtils.ageFileFilter((File)reference);
        IOFileFilter filter8 = FileFilterUtils.ageFileFilter((File)reference, (boolean)true);
        IOFileFilter filter9 = FileFilterUtils.ageFileFilter((File)reference, (boolean)false);
        this.assertFiltering(filter1, oldFile, true);
        this.assertFiltering(filter2, oldFile, true);
        this.assertFiltering(filter3, oldFile, false);
        this.assertFiltering(filter4, oldFile, true);
        this.assertFiltering(filter5, oldFile, true);
        this.assertFiltering(filter6, oldFile, false);
        this.assertFiltering(filter7, oldFile, true);
        this.assertFiltering(filter8, oldFile, true);
        this.assertFiltering(filter9, oldFile, false);
        this.assertFiltering(filter1, newFile, false);
        this.assertFiltering(filter2, newFile, false);
        this.assertFiltering(filter3, newFile, true);
        this.assertFiltering(filter4, newFile, false);
        this.assertFiltering(filter5, newFile, false);
        this.assertFiltering(filter6, newFile, true);
        this.assertFiltering(filter7, newFile, false);
        this.assertFiltering(filter8, newFile, false);
        this.assertFiltering(filter9, newFile, true);
    }

    public void testSizeFilter() throws Exception {
        File smallFile = new File(FileFilterTestCase.getTestDirectory(), "small.txt");
        this.createFile(smallFile, 32L);
        File largeFile = new File(FileFilterTestCase.getTestDirectory(), "large.txt");
        this.createFile(largeFile, 128L);
        IOFileFilter filter1 = FileFilterUtils.sizeFileFilter((long)64L);
        IOFileFilter filter2 = FileFilterUtils.sizeFileFilter((long)64L, (boolean)true);
        IOFileFilter filter3 = FileFilterUtils.sizeFileFilter((long)64L, (boolean)false);
        this.assertFiltering(filter1, smallFile, false);
        this.assertFiltering(filter2, smallFile, false);
        this.assertFiltering(filter3, smallFile, true);
        this.assertFiltering(filter1, largeFile, true);
        this.assertFiltering(filter2, largeFile, true);
        this.assertFiltering(filter3, largeFile, false);
        IOFileFilter filter4 = FileFilterUtils.sizeRangeFileFilter((long)33L, (long)127L);
        IOFileFilter filter5 = FileFilterUtils.sizeRangeFileFilter((long)32L, (long)127L);
        IOFileFilter filter6 = FileFilterUtils.sizeRangeFileFilter((long)33L, (long)128L);
        IOFileFilter filter7 = FileFilterUtils.sizeRangeFileFilter((long)31L, (long)129L);
        IOFileFilter filter8 = FileFilterUtils.sizeRangeFileFilter((long)128L, (long)128L);
        this.assertFiltering(filter4, smallFile, false);
        this.assertFiltering(filter4, largeFile, false);
        this.assertFiltering(filter5, smallFile, true);
        this.assertFiltering(filter5, largeFile, false);
        this.assertFiltering(filter6, smallFile, false);
        this.assertFiltering(filter6, largeFile, true);
        this.assertFiltering(filter7, smallFile, true);
        this.assertFiltering(filter7, largeFile, true);
        this.assertFiltering(filter8, largeFile, true);
        try {
            FileFilterUtils.sizeFileFilter((long)-1L);
            FileFilterTestCase.fail();
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
    }

    public void testHidden() throws Exception {
        File hiddenDir = new File(SVN_DIR_NAME);
        if (hiddenDir.exists()) {
            this.assertFiltering(HiddenFileFilter.HIDDEN, hiddenDir, hiddenDir.isHidden());
            this.assertFiltering(HiddenFileFilter.VISIBLE, hiddenDir, !hiddenDir.isHidden());
        }
        this.assertFiltering(HiddenFileFilter.HIDDEN, FileFilterTestCase.getTestDirectory(), false);
        this.assertFiltering(HiddenFileFilter.VISIBLE, FileFilterTestCase.getTestDirectory(), true);
    }

    public void testCanRead() throws Exception {
        File readOnlyFile = new File(FileFilterTestCase.getTestDirectory(), "read-only-file1.txt");
        this.createFile(readOnlyFile, 32L);
        readOnlyFile.setReadOnly();
        this.assertFiltering(CanReadFileFilter.CAN_READ, readOnlyFile, true);
        this.assertFiltering(CanReadFileFilter.CANNOT_READ, readOnlyFile, false);
        this.assertFiltering(CanReadFileFilter.READ_ONLY, readOnlyFile, true);
        readOnlyFile.delete();
    }

    public void testCanWrite() throws Exception {
        File readOnlyFile = new File(FileFilterTestCase.getTestDirectory(), "read-only-file2.txt");
        this.createFile(readOnlyFile, 32L);
        readOnlyFile.setReadOnly();
        this.assertFiltering(CanWriteFileFilter.CAN_WRITE, FileFilterTestCase.getTestDirectory(), true);
        this.assertFiltering(CanWriteFileFilter.CANNOT_WRITE, FileFilterTestCase.getTestDirectory(), false);
        this.assertFiltering(CanWriteFileFilter.CAN_WRITE, readOnlyFile, false);
        this.assertFiltering(CanWriteFileFilter.CANNOT_WRITE, readOnlyFile, true);
        readOnlyFile.delete();
    }

    public void testEmpty() throws Exception {
        File emptyDir = new File(FileFilterTestCase.getTestDirectory(), "empty-dir");
        emptyDir.mkdirs();
        this.assertFiltering(EmptyFileFilter.EMPTY, emptyDir, true);
        this.assertFiltering(EmptyFileFilter.NOT_EMPTY, emptyDir, false);
        File emptyFile = new File(emptyDir, "empty-file.txt");
        this.createFile(emptyFile, 0L);
        this.assertFiltering(EmptyFileFilter.EMPTY, emptyFile, true);
        this.assertFiltering(EmptyFileFilter.NOT_EMPTY, emptyFile, false);
        this.assertFiltering(EmptyFileFilter.EMPTY, emptyDir, false);
        this.assertFiltering(EmptyFileFilter.NOT_EMPTY, emptyDir, true);
        File notEmptyFile = new File(emptyDir, "not-empty-file.txt");
        this.createFile(notEmptyFile, 32L);
        this.assertFiltering(EmptyFileFilter.EMPTY, notEmptyFile, false);
        this.assertFiltering(EmptyFileFilter.NOT_EMPTY, notEmptyFile, true);
        FileUtils.forceDelete((File)emptyDir);
    }

    public void testMakeDirectoryOnly() throws Exception {
        FileFilterTestCase.assertSame((Object)DirectoryFileFilter.DIRECTORY, (Object)FileFilterUtils.makeDirectoryOnly(null));
        IOFileFilter filter = FileFilterUtils.makeDirectoryOnly((IOFileFilter)FileFilterUtils.nameFileFilter((String)"B"));
        File fileA = new File(FileFilterTestCase.getTestDirectory(), "A");
        File fileB = new File(FileFilterTestCase.getTestDirectory(), "B");
        fileA.mkdirs();
        fileB.mkdirs();
        this.assertFiltering(filter, fileA, false);
        this.assertFiltering(filter, fileB, true);
        FileUtils.deleteDirectory((File)fileA);
        FileUtils.deleteDirectory((File)fileB);
        this.createFile(fileA, 32L);
        this.createFile(fileB, 32L);
        this.assertFiltering(filter, fileA, false);
        this.assertFiltering(filter, fileB, false);
        fileA.delete();
        fileB.delete();
    }

    public void testMakeFileOnly() throws Exception {
        FileFilterTestCase.assertSame((Object)FileFileFilter.FILE, (Object)FileFilterUtils.makeFileOnly(null));
        IOFileFilter filter = FileFilterUtils.makeFileOnly((IOFileFilter)FileFilterUtils.nameFileFilter((String)"B"));
        File fileA = new File(FileFilterTestCase.getTestDirectory(), "A");
        File fileB = new File(FileFilterTestCase.getTestDirectory(), "B");
        fileA.mkdirs();
        fileB.mkdirs();
        this.assertFiltering(filter, fileA, false);
        this.assertFiltering(filter, fileB, false);
        FileUtils.deleteDirectory((File)fileA);
        FileUtils.deleteDirectory((File)fileB);
        this.createFile(fileA, 32L);
        this.createFile(fileB, 32L);
        this.assertFiltering(filter, fileA, false);
        this.assertFiltering(filter, fileB, true);
        fileA.delete();
        fileB.delete();
    }

    public void testMagicNumberFileFilterBytes() throws Exception {
        byte[] classFileMagicNumber = new byte[]{-54, -2, -70, -66};
        String xmlFileContent = "<?xml version=\"1.0\" encoding=\"UTF-8\">\n<element>text</element>";
        File classFileA = new File(FileFilterTestCase.getTestDirectory(), "A.class");
        File xmlFileB = new File(FileFilterTestCase.getTestDirectory(), "B.xml");
        File emptyFile = new File(FileFilterTestCase.getTestDirectory(), "C.xml");
        File dir = new File(FileFilterTestCase.getTestDirectory(), "D");
        dir.mkdirs();
        FileOutputStream classFileAStream = FileUtils.openOutputStream((File)classFileA);
        IOUtils.write((byte[])classFileMagicNumber, (OutputStream)classFileAStream);
        this.generateTestData(classFileAStream, 32L);
        ((OutputStream)classFileAStream).close();
        FileUtils.write((File)xmlFileB, (CharSequence)xmlFileContent);
        FileUtils.touch((File)emptyFile);
        MagicNumberFileFilter filter = new MagicNumberFileFilter(classFileMagicNumber);
        this.assertFiltering((IOFileFilter)filter, classFileA, true);
        this.assertFiltering((IOFileFilter)filter, xmlFileB, false);
        this.assertFiltering((IOFileFilter)filter, emptyFile, false);
        this.assertFiltering((IOFileFilter)filter, dir, false);
        filter = FileFilterUtils.magicNumberFileFilter((byte[])classFileMagicNumber);
        this.assertFiltering((IOFileFilter)filter, classFileA, true);
        this.assertFiltering((IOFileFilter)filter, xmlFileB, false);
        this.assertFiltering((IOFileFilter)filter, emptyFile, false);
        this.assertFiltering((IOFileFilter)filter, dir, false);
    }

    public void testMagicNumberFileFilterBytesOffset() throws Exception {
        byte[] tarMagicNumber = new byte[]{117, 115, 116, 97, 114};
        long tarMagicNumberOffset = 257L;
        File tarFileA = new File(FileFilterTestCase.getTestDirectory(), "A.tar");
        File randomFileB = new File(FileFilterTestCase.getTestDirectory(), "B.txt");
        File dir = new File(FileFilterTestCase.getTestDirectory(), "D");
        dir.mkdirs();
        FileOutputStream tarFileAStream = FileUtils.openOutputStream((File)tarFileA);
        this.generateTestData(tarFileAStream, tarMagicNumberOffset);
        IOUtils.write((byte[])tarMagicNumber, (OutputStream)tarFileAStream);
        ((OutputStream)tarFileAStream).close();
        this.createFile(randomFileB, 2L * tarMagicNumberOffset);
        MagicNumberFileFilter filter = new MagicNumberFileFilter(tarMagicNumber, tarMagicNumberOffset);
        this.assertFiltering((IOFileFilter)filter, tarFileA, true);
        this.assertFiltering((IOFileFilter)filter, randomFileB, false);
        this.assertFiltering((IOFileFilter)filter, dir, false);
        filter = FileFilterUtils.magicNumberFileFilter((byte[])tarMagicNumber, (long)tarMagicNumberOffset);
        this.assertFiltering((IOFileFilter)filter, tarFileA, true);
        this.assertFiltering((IOFileFilter)filter, randomFileB, false);
        this.assertFiltering((IOFileFilter)filter, dir, false);
    }

    public void testMagicNumberFileFilterString() throws Exception {
        byte[] classFileMagicNumber = new byte[]{-54, -2, -70, -66};
        String xmlFileContent = "<?xml version=\"1.0\" encoding=\"UTF-8\">\n<element>text</element>";
        String xmlMagicNumber = "<?xml version=\"1.0\"";
        File classFileA = new File(FileFilterTestCase.getTestDirectory(), "A.class");
        File xmlFileB = new File(FileFilterTestCase.getTestDirectory(), "B.xml");
        File dir = new File(FileFilterTestCase.getTestDirectory(), "D");
        dir.mkdirs();
        FileOutputStream classFileAStream = FileUtils.openOutputStream((File)classFileA);
        IOUtils.write((byte[])classFileMagicNumber, (OutputStream)classFileAStream);
        this.generateTestData(classFileAStream, 32L);
        ((OutputStream)classFileAStream).close();
        FileUtils.write((File)xmlFileB, (CharSequence)xmlFileContent);
        MagicNumberFileFilter filter = new MagicNumberFileFilter(xmlMagicNumber);
        this.assertFiltering((IOFileFilter)filter, classFileA, false);
        this.assertFiltering((IOFileFilter)filter, xmlFileB, true);
        this.assertFiltering((IOFileFilter)filter, dir, false);
        filter = FileFilterUtils.magicNumberFileFilter((String)xmlMagicNumber);
        this.assertFiltering((IOFileFilter)filter, classFileA, false);
        this.assertFiltering((IOFileFilter)filter, xmlFileB, true);
        this.assertFiltering((IOFileFilter)filter, dir, false);
    }

    public void testMagicNumberFileFilterStringOffset() throws Exception {
        String tarMagicNumber = "ustar";
        long tarMagicNumberOffset = 257L;
        File tarFileA = new File(FileFilterTestCase.getTestDirectory(), "A.tar");
        File randomFileB = new File(FileFilterTestCase.getTestDirectory(), "B.txt");
        File dir = new File(FileFilterTestCase.getTestDirectory(), "D");
        dir.mkdirs();
        FileOutputStream tarFileAStream = FileUtils.openOutputStream((File)tarFileA);
        this.generateTestData(tarFileAStream, tarMagicNumberOffset);
        IOUtils.write((String)tarMagicNumber, (OutputStream)tarFileAStream);
        ((OutputStream)tarFileAStream).close();
        this.createFile(randomFileB, 2L * tarMagicNumberOffset);
        MagicNumberFileFilter filter = new MagicNumberFileFilter(tarMagicNumber, tarMagicNumberOffset);
        this.assertFiltering((IOFileFilter)filter, tarFileA, true);
        this.assertFiltering((IOFileFilter)filter, randomFileB, false);
        this.assertFiltering((IOFileFilter)filter, dir, false);
        filter = FileFilterUtils.magicNumberFileFilter((String)tarMagicNumber, (long)tarMagicNumberOffset);
        this.assertFiltering((IOFileFilter)filter, tarFileA, true);
        this.assertFiltering((IOFileFilter)filter, randomFileB, false);
        this.assertFiltering((IOFileFilter)filter, dir, false);
    }

    public void testMagicNumberFileFilterValidation() {
        try {
            new MagicNumberFileFilter((String)null, 0L);
            FileFilterTestCase.fail();
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            new MagicNumberFileFilter("0", -1L);
            FileFilterTestCase.fail();
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            new MagicNumberFileFilter("", 0L);
            FileFilterTestCase.fail();
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            new MagicNumberFileFilter((byte[])null, 0L);
            FileFilterTestCase.fail();
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            new MagicNumberFileFilter(new byte[]{0}, -1L);
            FileFilterTestCase.fail();
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        try {
            new MagicNumberFileFilter(new byte[0], 0L);
            FileFilterTestCase.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testFilterArray() throws Exception {
        File fileA = this.newFile("A");
        File fileB = this.newFile("B");
        IOFileFilter filter = FileFilterUtils.nameFileFilter((String)"A");
        File[] filtered = FileFilterUtils.filter((IOFileFilter)filter, (File[])new File[]{fileA, fileB});
        FileFilterTestCase.assertEquals((int)1, (int)filtered.length);
        FileFilterTestCase.assertEquals((Object)fileA, (Object)filtered[0]);
    }

    public void testFilterArray_fromList() throws Exception {
        File fileA = this.newFile("A");
        File fileB = this.newFile("B");
        List<File> fileList = Arrays.asList(fileA, fileB);
        IOFileFilter filter = FileFilterUtils.nameFileFilter((String)"A");
        File[] filtered = FileFilterUtils.filter((IOFileFilter)filter, fileList);
        FileFilterTestCase.assertEquals((int)1, (int)filtered.length);
        FileFilterTestCase.assertEquals((Object)fileA, (Object)filtered[0]);
    }

    public void testFilterArrayNullParameters() throws Exception {
        File fileA = this.newFile("A");
        File fileB = this.newFile("B");
        try {
            FileFilterUtils.filter(null, (File[])new File[]{fileA, fileB});
            FileFilterTestCase.fail();
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        IOFileFilter filter = FileFilterUtils.trueFileFilter();
        try {
            FileFilterUtils.filter((IOFileFilter)filter, (File[])new File[]{fileA, null});
            FileFilterTestCase.fail();
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        File[] filtered = FileFilterUtils.filter((IOFileFilter)filter, (File[])null);
        FileFilterTestCase.assertEquals((int)0, (int)filtered.length);
    }

    public void testFilterList() throws Exception {
        File fileA = this.newFile("A");
        File fileB = this.newFile("B");
        List<File> fileList = Arrays.asList(fileA, fileB);
        IOFileFilter filter = FileFilterUtils.nameFileFilter((String)"A");
        List filteredList = FileFilterUtils.filterList((IOFileFilter)filter, fileList);
        FileFilterTestCase.assertTrue((boolean)filteredList.contains(fileA));
        FileFilterTestCase.assertFalse((boolean)filteredList.contains(fileB));
    }

    public void testFilterList_fromArray() throws Exception {
        File fileA = this.newFile("A");
        File fileB = this.newFile("B");
        IOFileFilter filter = FileFilterUtils.nameFileFilter((String)"A");
        List filteredList = FileFilterUtils.filterList((IOFileFilter)filter, (File[])new File[]{fileA, fileB});
        FileFilterTestCase.assertTrue((boolean)filteredList.contains(fileA));
        FileFilterTestCase.assertFalse((boolean)filteredList.contains(fileB));
    }

    public void testFilterListNullParameters() {
        try {
            FileFilterUtils.filterList(null, Collections.emptyList());
            FileFilterTestCase.fail();
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        IOFileFilter filter = FileFilterUtils.trueFileFilter();
        try {
            FileFilterUtils.filterList((IOFileFilter)filter, Arrays.asList(new File[]{null}));
            FileFilterTestCase.fail();
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        List filteredList = FileFilterUtils.filterList((IOFileFilter)filter, (Iterable)null);
        FileFilterTestCase.assertEquals((int)0, (int)filteredList.size());
    }

    public void testFilterSet() throws Exception {
        File fileA = this.newFile("A");
        File fileB = this.newFile("B");
        HashSet<File> fileList = new HashSet<File>(Arrays.asList(fileA, fileB));
        IOFileFilter filter = FileFilterUtils.nameFileFilter((String)"A");
        Set filteredSet = FileFilterUtils.filterSet((IOFileFilter)filter, fileList);
        FileFilterTestCase.assertTrue((boolean)filteredSet.contains(fileA));
        FileFilterTestCase.assertFalse((boolean)filteredSet.contains(fileB));
    }

    public void testFilterSet_fromArray() throws Exception {
        File fileA = this.newFile("A");
        File fileB = this.newFile("B");
        IOFileFilter filter = FileFilterUtils.nameFileFilter((String)"A");
        Set filteredSet = FileFilterUtils.filterSet((IOFileFilter)filter, (File[])new File[]{fileA, fileB});
        FileFilterTestCase.assertTrue((boolean)filteredSet.contains(fileA));
        FileFilterTestCase.assertFalse((boolean)filteredSet.contains(fileB));
    }

    public void testFilterSetNullParameters() {
        try {
            FileFilterUtils.filterSet(null, Collections.emptySet());
            FileFilterTestCase.fail();
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        IOFileFilter filter = FileFilterUtils.trueFileFilter();
        try {
            FileFilterUtils.filterSet((IOFileFilter)filter, new HashSet<File>(Arrays.asList(new File[]{null})));
            FileFilterTestCase.fail();
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        Set filteredSet = FileFilterUtils.filterSet((IOFileFilter)filter, (Iterable)null);
        FileFilterTestCase.assertEquals((int)0, (int)filteredSet.size());
    }

    public void testEnsureTestCoverage() {
        FileFilterTestCase.assertNotNull((Object)new FileFilterUtils());
    }

    public void testNullFilters() {
        try {
            FileFilterUtils.toList((IOFileFilter[])new IOFileFilter[]{null});
            FileFilterTestCase.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        try {
            FileFilterUtils.toList((IOFileFilter[])new IOFileFilter[]{null});
            FileFilterTestCase.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testDelegation() {
        FileFilterTestCase.assertNotNull((Object)FileFilterUtils.asFileFilter((FileFilter)FalseFileFilter.INSTANCE));
        FileFilterTestCase.assertNotNull((Object)FileFilterUtils.asFileFilter((FilenameFilter)FalseFileFilter.INSTANCE).toString());
    }
}

