/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.filefilter;

import java.io.File;
import junit.framework.TestCase;
import org.apache.commons.io.filefilter.FalseFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;

public abstract class IOFileFilterAbstractTestCase
extends TestCase {
    public IOFileFilterAbstractTestCase(String name) {
        super(name);
    }

    public boolean assertFileFiltering(int testNumber, IOFileFilter filter, File file, boolean expected) throws Exception {
        IOFileFilterAbstractTestCase.assertEquals((String)("test " + testNumber + " Filter(File) " + filter.getClass().getName() + " not " + expected + " for " + file), (boolean)expected, (boolean)filter.accept(file));
        return true;
    }

    public boolean assertFilenameFiltering(int testNumber, IOFileFilter filter, File file, boolean expected) throws Exception {
        IOFileFilterAbstractTestCase.assertEquals((String)("test " + testNumber + " Filter(File, String) " + filter.getClass().getName() + " not " + expected + " for " + file), (boolean)expected, (boolean)filter.accept(file.getParentFile(), file.getName()));
        return true;
    }

    public void assertFiltering(int testNumber, IOFileFilter filter, File file, boolean expected) throws Exception {
        IOFileFilterAbstractTestCase.assertEquals((String)("test " + testNumber + " Filter(File) " + filter.getClass().getName() + " not " + expected + " for " + file), (boolean)expected, (boolean)filter.accept(file));
        if (file != null && file.getParentFile() != null) {
            IOFileFilterAbstractTestCase.assertEquals((String)("test " + testNumber + " Filter(File, String) " + filter.getClass().getName() + " not " + expected + " for " + file), (boolean)expected, (boolean)filter.accept(file.getParentFile(), file.getName()));
        } else if (file == null) {
            IOFileFilterAbstractTestCase.assertEquals((String)("test " + testNumber + " Filter(File, String) " + filter.getClass().getName() + " not " + expected + " for null"), (boolean)expected, (boolean)filter.accept(file));
        }
    }

    public void assertTrueFiltersInvoked(int testNumber, TesterTrueFileFilter[] filters, boolean[] invoked) {
        for (int i = 1; i < filters.length; ++i) {
            IOFileFilterAbstractTestCase.assertEquals((String)("test " + testNumber + " filter " + i + " invoked"), (boolean)invoked[i - 1], (boolean)filters[i].isInvoked());
        }
    }

    public void assertFalseFiltersInvoked(int testNumber, TesterFalseFileFilter[] filters, boolean[] invoked) {
        for (int i = 1; i < filters.length; ++i) {
            IOFileFilterAbstractTestCase.assertEquals((String)("test " + testNumber + " filter " + i + " invoked"), (boolean)invoked[i - 1], (boolean)filters[i].isInvoked());
        }
    }

    public File determineWorkingDirectoryPath(String key, String defaultPath) {
        String workingPathName = System.getProperty(key, defaultPath);
        return new File(workingPathName);
    }

    public void resetFalseFilters(TesterFalseFileFilter[] filters) {
        for (TesterFalseFileFilter filter : filters) {
            if (filter == null) continue;
            filter.reset();
        }
    }

    public void resetTrueFilters(TesterTrueFileFilter[] filters) {
        for (TesterTrueFileFilter filter : filters) {
            if (filter == null) continue;
            filter.reset();
        }
    }

    class TesterFalseFileFilter
    extends FalseFileFilter {
        private boolean invoked;

        TesterFalseFileFilter() {
        }

        public boolean accept(File file) {
            this.setInvoked(true);
            return super.accept(file);
        }

        public boolean accept(File file, String str) {
            this.setInvoked(true);
            return super.accept(file, str);
        }

        public boolean isInvoked() {
            return this.invoked;
        }

        public void setInvoked(boolean invoked) {
            this.invoked = invoked;
        }

        public void reset() {
            this.setInvoked(false);
        }
    }

    class TesterTrueFileFilter
    extends TrueFileFilter {
        private boolean invoked;

        TesterTrueFileFilter() {
        }

        public boolean accept(File file) {
            this.setInvoked(true);
            return super.accept(file);
        }

        public boolean accept(File file, String str) {
            this.setInvoked(true);
            return super.accept(file, str);
        }

        public boolean isInvoked() {
            return this.invoked;
        }

        public void setInvoked(boolean invoked) {
            this.invoked = invoked;
        }

        public void reset() {
            this.setInvoked(false);
        }
    }
}

