/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import junit.framework.TestCase;
import org.apache.commons.io.ByteOrderMark;
import org.apache.commons.io.input.BOMInputStream;
import org.junit.Assert;

public class BOMInputStreamTest
extends TestCase {
    public InputStream createDataStream(byte[] baseData, boolean addBOM) {
        byte[] data = baseData;
        if (addBOM) {
            data = new byte[baseData.length + 3];
            data[0] = -17;
            data[1] = -69;
            data[2] = -65;
            System.arraycopy(baseData, 0, data, 3, baseData.length);
        }
        return new ByteArrayInputStream(data);
    }

    private void assertData(byte[] expected, byte[] actual, int len) throws Exception {
        BOMInputStreamTest.assertEquals((String)"length", (int)expected.length, (int)len);
        for (int ii = 0; ii < expected.length; ++ii) {
            BOMInputStreamTest.assertEquals((String)("byte " + ii), (byte)expected[ii], (byte)actual[ii]);
        }
    }

    public void testSupportCode() throws Exception {
        InputStream in = this.createDataStream(new byte[]{65, 66}, true);
        byte[] buf = new byte[1024];
        int len = in.read(buf);
        BOMInputStreamTest.assertEquals((int)5, (int)len);
        BOMInputStreamTest.assertEquals((int)239, (int)(buf[0] & 0xFF));
        BOMInputStreamTest.assertEquals((int)187, (int)(buf[1] & 0xFF));
        BOMInputStreamTest.assertEquals((int)191, (int)(buf[2] & 0xFF));
        BOMInputStreamTest.assertEquals((int)65, (int)(buf[3] & 0xFF));
        BOMInputStreamTest.assertEquals((int)66, (int)(buf[4] & 0xFF));
        this.assertData(new byte[]{-17, -69, -65, 65, 66}, buf, len);
    }

    public void testReadWithoutBOM() throws Exception {
        byte[] data = new byte[]{65, 66, 67};
        BOMInputStream in = new BOMInputStream(this.createDataStream(data, false));
        BOMInputStreamTest.assertEquals((int)65, (int)in.read());
        BOMInputStreamTest.assertEquals((int)66, (int)in.read());
        BOMInputStreamTest.assertEquals((int)67, (int)in.read());
        BOMInputStreamTest.assertEquals((int)-1, (int)in.read());
        BOMInputStreamTest.assertFalse((String)"hasBOM()", (boolean)in.hasBOM());
        BOMInputStreamTest.assertFalse((String)"hasBOM(UTF-8)", (boolean)in.hasBOM(ByteOrderMark.UTF_8));
        BOMInputStreamTest.assertNull((String)"getBOM", (Object)in.getBOM());
    }

    public void testReadEmpty() throws Exception {
        byte[] data = new byte[]{};
        BOMInputStream in = new BOMInputStream(this.createDataStream(data, false));
        BOMInputStreamTest.assertEquals((int)-1, (int)in.read());
        BOMInputStreamTest.assertFalse((String)"hasBOM()", (boolean)in.hasBOM());
        BOMInputStreamTest.assertFalse((String)"hasBOM(UTF-8)", (boolean)in.hasBOM(ByteOrderMark.UTF_8));
        BOMInputStreamTest.assertNull((String)"getBOM", (Object)in.getBOM());
    }

    public void testReadSmall() throws Exception {
        byte[] data = new byte[]{65, 66};
        BOMInputStream in = new BOMInputStream(this.createDataStream(data, false));
        BOMInputStreamTest.assertEquals((int)65, (int)in.read());
        BOMInputStreamTest.assertEquals((int)66, (int)in.read());
        BOMInputStreamTest.assertEquals((int)-1, (int)in.read());
        BOMInputStreamTest.assertFalse((String)"hasBOM()", (boolean)in.hasBOM());
        BOMInputStreamTest.assertFalse((String)"hasBOM(UTF-8)", (boolean)in.hasBOM(ByteOrderMark.UTF_8));
        BOMInputStreamTest.assertNull((String)"getBOM", (Object)in.getBOM());
    }

    public void testReadWithBOM() throws Exception {
        byte[] data = new byte[]{65, 66, 67};
        BOMInputStream in = new BOMInputStream(this.createDataStream(data, true));
        BOMInputStreamTest.assertEquals((int)65, (int)in.read());
        BOMInputStreamTest.assertEquals((int)66, (int)in.read());
        BOMInputStreamTest.assertEquals((int)67, (int)in.read());
        BOMInputStreamTest.assertEquals((int)-1, (int)in.read());
        BOMInputStreamTest.assertTrue((String)"hasBOM()", (boolean)in.hasBOM());
        BOMInputStreamTest.assertTrue((String)"hasBOM(UTF-8)", (boolean)in.hasBOM(ByteOrderMark.UTF_8));
        BOMInputStreamTest.assertEquals((String)"getBOM", (Object)ByteOrderMark.UTF_8, (Object)in.getBOM());
        try {
            in.hasBOM(ByteOrderMark.UTF_16BE);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetBOMFirstThenRead() throws Exception {
        byte[] data = new byte[]{65, 66, 67};
        BOMInputStream in = new BOMInputStream(this.createDataStream(data, true));
        BOMInputStreamTest.assertEquals((String)"getBOM", (Object)ByteOrderMark.UTF_8, (Object)in.getBOM());
        BOMInputStreamTest.assertTrue((String)"hasBOM()", (boolean)in.hasBOM());
        BOMInputStreamTest.assertTrue((String)"hasBOM(UTF-8)", (boolean)in.hasBOM(ByteOrderMark.UTF_8));
        BOMInputStreamTest.assertEquals((int)65, (int)in.read());
        BOMInputStreamTest.assertEquals((int)66, (int)in.read());
        BOMInputStreamTest.assertEquals((int)67, (int)in.read());
        BOMInputStreamTest.assertEquals((int)-1, (int)in.read());
    }

    public void testReadWithBOMInclude() throws Exception {
        byte[] data = new byte[]{65, 66, 67};
        BOMInputStream in = new BOMInputStream(this.createDataStream(data, true), true);
        BOMInputStreamTest.assertEquals((int)239, (int)in.read());
        BOMInputStreamTest.assertEquals((int)187, (int)in.read());
        BOMInputStreamTest.assertEquals((int)191, (int)in.read());
        BOMInputStreamTest.assertEquals((int)65, (int)in.read());
        BOMInputStreamTest.assertEquals((int)66, (int)in.read());
        BOMInputStreamTest.assertEquals((int)67, (int)in.read());
        BOMInputStreamTest.assertEquals((int)-1, (int)in.read());
        BOMInputStreamTest.assertTrue((String)"hasBOM()", (boolean)in.hasBOM());
        BOMInputStreamTest.assertTrue((String)"hasBOM(UTF-8)", (boolean)in.hasBOM(ByteOrderMark.UTF_8));
        BOMInputStreamTest.assertEquals((String)"getBOM", (Object)ByteOrderMark.UTF_8, (Object)in.getBOM());
    }

    public void testGetBOMFirstThenReadInclude() throws Exception {
        byte[] data = new byte[]{65, 66, 67};
        BOMInputStream in = new BOMInputStream(this.createDataStream(data, true), true);
        BOMInputStreamTest.assertTrue((String)"hasBOM()", (boolean)in.hasBOM());
        BOMInputStreamTest.assertTrue((String)"hasBOM(UTF-8)", (boolean)in.hasBOM(ByteOrderMark.UTF_8));
        BOMInputStreamTest.assertEquals((String)"getBOM", (Object)ByteOrderMark.UTF_8, (Object)in.getBOM());
        BOMInputStreamTest.assertEquals((int)239, (int)in.read());
        BOMInputStreamTest.assertEquals((int)187, (int)in.read());
        BOMInputStreamTest.assertEquals((int)191, (int)in.read());
        BOMInputStreamTest.assertEquals((int)65, (int)in.read());
        BOMInputStreamTest.assertEquals((int)66, (int)in.read());
        BOMInputStreamTest.assertEquals((int)67, (int)in.read());
        BOMInputStreamTest.assertEquals((int)-1, (int)in.read());
    }

    public void testReadWithMultipleBOM() throws Exception {
        byte[] data = new byte[]{65, 66, 67};
        BOMInputStream in = new BOMInputStream(this.createDataStream(data, true), new ByteOrderMark[]{ByteOrderMark.UTF_16BE, ByteOrderMark.UTF_8});
        BOMInputStreamTest.assertEquals((int)65, (int)in.read());
        BOMInputStreamTest.assertEquals((int)66, (int)in.read());
        BOMInputStreamTest.assertEquals((int)67, (int)in.read());
        BOMInputStreamTest.assertEquals((int)-1, (int)in.read());
        BOMInputStreamTest.assertTrue((String)"hasBOM()", (boolean)in.hasBOM());
        BOMInputStreamTest.assertTrue((String)"hasBOM(UTF-8)", (boolean)in.hasBOM(ByteOrderMark.UTF_8));
        BOMInputStreamTest.assertFalse((String)"hasBOM(UTF-16BE)", (boolean)in.hasBOM(ByteOrderMark.UTF_16BE));
        BOMInputStreamTest.assertEquals((String)"getBOM", (Object)ByteOrderMark.UTF_8, (Object)in.getBOM());
    }

    public void testEmptyBufferWithoutBOM() throws Exception {
        byte[] data = new byte[]{};
        BOMInputStream in = new BOMInputStream(this.createDataStream(data, false));
        byte[] buf = new byte[1024];
        BOMInputStreamTest.assertEquals((int)-1, (int)in.read(buf));
    }

    public void testEmptyBufferWithBOM() throws Exception {
        byte[] data = new byte[]{};
        BOMInputStream in = new BOMInputStream(this.createDataStream(data, true));
        byte[] buf = new byte[1024];
        BOMInputStreamTest.assertEquals((int)-1, (int)in.read(buf));
    }

    public void testLargeBufferWithoutBOM() throws Exception {
        byte[] data = new byte[]{65, 66, 67};
        BOMInputStream in = new BOMInputStream(this.createDataStream(data, false));
        byte[] buf = new byte[1024];
        this.assertData(data, buf, in.read(buf));
    }

    public void testLargeBufferWithBOM() throws Exception {
        byte[] data = new byte[]{65, 66, 67};
        BOMInputStream in = new BOMInputStream(this.createDataStream(data, true));
        byte[] buf = new byte[1024];
        this.assertData(data, buf, in.read(buf));
    }

    public void testSmallBufferWithoutBOM() throws Exception {
        byte[] data = new byte[]{65, 66, 67};
        BOMInputStream in = new BOMInputStream(this.createDataStream(data, false));
        byte[] buf = new byte[1024];
        this.assertData(new byte[]{65, 66}, buf, in.read(buf, 0, 2));
        this.assertData(new byte[]{67}, buf, in.read(buf, 0, 2));
    }

    public void testSmallBufferWithBOM() throws Exception {
        byte[] data = new byte[]{65, 66, 67};
        BOMInputStream in = new BOMInputStream(this.createDataStream(data, true));
        byte[] buf = new byte[1024];
        this.assertData(new byte[]{65, 66}, buf, in.read(buf, 0, 2));
        this.assertData(new byte[]{67}, buf, in.read(buf, 0, 2));
    }

    public void testLeadingNonBOMSingleRead() throws Exception {
        byte[] data = new byte[]{-17, -85, -51};
        BOMInputStream in = new BOMInputStream(this.createDataStream(data, false));
        BOMInputStreamTest.assertEquals((int)239, (int)in.read());
        BOMInputStreamTest.assertEquals((int)171, (int)in.read());
        BOMInputStreamTest.assertEquals((int)205, (int)in.read());
        BOMInputStreamTest.assertEquals((int)-1, (int)in.read());
    }

    public void testLeadingNonBOMBufferedRead() throws Exception {
        byte[] data = new byte[]{-17, -85, -51};
        BOMInputStream in = new BOMInputStream(this.createDataStream(data, false));
        byte[] buf = new byte[1024];
        this.assertData(data, buf, in.read(buf));
    }

    public void testSkipWithoutBOM() throws Exception {
        byte[] data = new byte[]{65, 66, 67, 68};
        BOMInputStream in = new BOMInputStream(this.createDataStream(data, false));
        in.skip(2L);
        BOMInputStreamTest.assertEquals((int)67, (int)in.read());
    }

    public void testSkipWithBOM() throws Exception {
        byte[] data = new byte[]{65, 66, 67, 68};
        BOMInputStream in = new BOMInputStream(this.createDataStream(data, true));
        in.skip(2L);
        BOMInputStreamTest.assertEquals((int)67, (int)in.read());
    }

    public void testMarkResetAfterReadWithoutBOM() throws Exception {
        byte[] data = new byte[]{65, 66, 67, 68};
        BOMInputStream in = new BOMInputStream(this.createDataStream(data, false));
        BOMInputStreamTest.assertTrue((boolean)in.markSupported());
        in.read();
        in.mark(10);
        in.read();
        in.read();
        in.reset();
        BOMInputStreamTest.assertEquals((int)66, (int)in.read());
    }

    public void testMarkResetAfterReadWithBOM() throws Exception {
        byte[] data = new byte[]{65, 66, 67, 68};
        BOMInputStream in = new BOMInputStream(this.createDataStream(data, true));
        BOMInputStreamTest.assertTrue((boolean)in.markSupported());
        in.read();
        in.mark(10);
        in.read();
        in.read();
        in.reset();
        BOMInputStreamTest.assertEquals((int)66, (int)in.read());
    }

    public void testMarkResetBeforeReadWithoutBOM() throws Exception {
        byte[] data = new byte[]{65, 66, 67, 68};
        BOMInputStream in = new BOMInputStream(this.createDataStream(data, false));
        BOMInputStreamTest.assertTrue((boolean)in.markSupported());
        in.mark(10);
        in.read();
        in.read();
        in.reset();
        BOMInputStreamTest.assertEquals((int)65, (int)in.read());
    }

    public void testMarkResetBeforeReadWithBOM() throws Exception {
        byte[] data = new byte[]{65, 66, 67, 68};
        BOMInputStream in = new BOMInputStream(this.createDataStream(data, true));
        BOMInputStreamTest.assertTrue((boolean)in.markSupported());
        in.mark(10);
        in.read();
        in.read();
        in.reset();
        BOMInputStreamTest.assertEquals((int)65, (int)in.read());
    }

    public void testAvailableWithoutBOM() throws Exception {
        byte[] data = new byte[]{65, 66, 67, 68};
        BOMInputStream in = new BOMInputStream(this.createDataStream(data, false));
        BOMInputStreamTest.assertEquals((int)4, (int)in.available());
    }

    public void testAvailableWithBOM() throws Exception {
        byte[] data = new byte[]{65, 66, 67, 68};
        BOMInputStream in = new BOMInputStream(this.createDataStream(data, true));
        BOMInputStreamTest.assertEquals((int)7, (int)in.available());
    }

    public void testNoBoms() throws Exception {
        byte[] data = new byte[]{65, 66, 67};
        try {
            new BOMInputStream(this.createDataStream(data, true), false, (ByteOrderMark[])null);
            BOMInputStreamTest.fail((String)"Null BOMs, expected IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            new BOMInputStream(this.createDataStream(data, true), false, new ByteOrderMark[0]);
            BOMInputStreamTest.fail((String)"Null BOMs, expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testReadTwiceWithoutBOM() throws Exception {
        this.readBOMInputStreamTwice("/org/apache/commons/io/testfileNoBOM.xml");
    }

    public void testReadTwiceWithBOM() throws Exception {
        this.readBOMInputStreamTwice("/org/apache/commons/io/testfileBOM.xml");
    }

    public void readBOMInputStreamTwice(String resource) throws Exception {
        InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream(resource);
        Assert.assertNotNull((Object)inputStream);
        BOMInputStream bomInputStream = new BOMInputStream(inputStream);
        bomInputStream.mark(1000000);
        this.readFile(bomInputStream);
        bomInputStream.reset();
        this.readFile(bomInputStream);
    }

    private void readFile(BOMInputStream bomInputStream) throws Exception {
        int bytes = 0;
        byte[] bytesFromStream = new byte[100];
        while ((bytes = bomInputStream.read(bytesFromStream)) > 0) {
        }
    }

    public void testClose() throws Exception {
        ExpectCloseInputStream del = new ExpectCloseInputStream();
        BOMInputStream in = new BOMInputStream((InputStream)del);
        in.close();
        del.assertCloseCalled();
    }

    private static class ExpectCloseInputStream
    extends InputStream {
        private boolean _closeCalled;

        private ExpectCloseInputStream() {
        }

        @Override
        public void close() throws IOException {
            this._closeCalled = true;
        }

        @Override
        public int read() throws IOException {
            return -1;
        }

        public void assertCloseCalled() {
            junit.framework.Assert.assertTrue((boolean)this._closeCalled);
        }
    }
}

