/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.CharArrayReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.Random;
import org.apache.commons.io.input.ReaderInputStream;
import org.junit.Assert;
import org.junit.Test;

public class ReaderInputStreamTest {
    private static final String TEST_STRING = "\u00e0 peine arriv\u00e9s nous entr\u00e2mes dans sa chambre";
    private static final String LARGE_TEST_STRING;
    private Random random = new Random();

    private void testWithSingleByteRead(String testString, String charsetName) throws IOException {
        byte[] bytes = testString.getBytes(charsetName);
        ReaderInputStream in = new ReaderInputStream((Reader)new StringReader(testString), charsetName);
        for (byte b : bytes) {
            int read = in.read();
            Assert.assertTrue((read >= 0 ? 1 : 0) != 0);
            Assert.assertTrue((read <= 255 ? 1 : 0) != 0);
            Assert.assertEquals((long)b, (long)((byte)read));
        }
        Assert.assertEquals((long)-1L, (long)in.read());
    }

    private void testWithBufferedRead(String testString, String charsetName) throws IOException {
        byte[] expected = testString.getBytes(charsetName);
        ReaderInputStream in = new ReaderInputStream((Reader)new StringReader(testString), charsetName);
        byte[] buffer = new byte[128];
        int offset = 0;
        block0: while (true) {
            int bufferLength;
            int bufferOffset;
            int read;
            if ((read = in.read(buffer, bufferOffset = this.random.nextInt(64), bufferLength = this.random.nextInt(64))) == -1) {
                Assert.assertEquals((long)offset, (long)expected.length);
                break;
            }
            Assert.assertTrue((read <= bufferLength ? 1 : 0) != 0);
            while (true) {
                if (read <= 0) continue block0;
                Assert.assertTrue((offset < expected.length ? 1 : 0) != 0);
                Assert.assertEquals((long)expected[offset], (long)buffer[bufferOffset]);
                ++offset;
                ++bufferOffset;
                --read;
            }
            break;
        }
    }

    @Test
    public void testUTF8WithSingleByteRead() throws IOException {
        this.testWithSingleByteRead(TEST_STRING, "UTF-8");
    }

    @Test
    public void testLargeUTF8WithSingleByteRead() throws IOException {
        this.testWithSingleByteRead(LARGE_TEST_STRING, "UTF-8");
    }

    @Test
    public void testUTF8WithBufferedRead() throws IOException {
        this.testWithBufferedRead(TEST_STRING, "UTF-8");
    }

    @Test
    public void testLargeUTF8WithBufferedRead() throws IOException {
        this.testWithBufferedRead(LARGE_TEST_STRING, "UTF-8");
    }

    @Test
    public void testUTF16WithSingleByteRead() throws IOException {
        this.testWithSingleByteRead(TEST_STRING, "UTF-16");
    }

    @Test
    public void testReadZero() throws Exception {
        String inStr = "test";
        ReaderInputStream r = new ReaderInputStream((Reader)new StringReader("test"));
        byte[] bytes = new byte[30];
        Assert.assertEquals((long)0L, (long)r.read(bytes, 0, 0));
        Assert.assertEquals((long)"test".length(), (long)r.read(bytes, 0, "test".length() + 1));
        Assert.assertEquals((long)0L, (long)r.read(bytes, 0, 0));
    }

    @Test
    public void testReadZeroEmptyString() throws Exception {
        ReaderInputStream r = new ReaderInputStream((Reader)new StringReader(""));
        byte[] bytes = new byte[30];
        Assert.assertEquals((long)0L, (long)r.read(bytes, 0, 0));
        Assert.assertEquals((long)-1L, (long)r.read(bytes, 0, 1));
        Assert.assertEquals((long)0L, (long)r.read(bytes, 0, 0));
        Assert.assertEquals((long)-1L, (long)r.read(bytes, 0, 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCharsetMismatchInfiniteLoop() throws IOException {
        char[] inputChars = new char[]{'\u00e0', '\u00b2', '\u00a0'};
        Charset charset = Charset.forName("ASCII");
        ReaderInputStream stream = new ReaderInputStream((Reader)new CharArrayReader(inputChars), charset);
        try {
            while (stream.read() != -1) {
            }
        }
        finally {
            stream.close();
        }
    }

    static {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < 100; ++i) {
            buffer.append(TEST_STRING);
        }
        LARGE_TEST_STRING = buffer.toString();
    }
}

