/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Stack;
import org.apache.commons.io.input.ReversedLinesFileReader;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ReversedLinesFileReaderTestParamFile {
    private ReversedLinesFileReader reversedLinesFileReader;
    private BufferedReader bufferedReader;
    private final String fileName;
    private final String encoding;
    private final int buffSize;

    @Parameterized.Parameters
    public static Collection<Object[]> blockSizes() {
        return Arrays.asList({"test-file-20byteslength.bin", "ISO_8859_1", null}, {"test-file-iso8859-1-shortlines-win-linebr.bin", "ISO_8859_1", null}, {"test-file-iso8859-1.bin", "ISO_8859_1", null}, {"test-file-shiftjis.bin", "Shift_JIS", null}, {"test-file-utf16be.bin", "UTF-16BE", null}, {"test-file-utf16le.bin", "UTF-16LE", null}, {"test-file-utf8-cr-only.bin", "UTF-8", null}, {"test-file-utf8-win-linebr.bin", "UTF-8", null}, {"test-file-utf8-win-linebr.bin", "UTF-8", 1}, {"test-file-utf8-win-linebr.bin", "UTF-8", 2}, {"test-file-utf8-win-linebr.bin", "UTF-8", 3}, {"test-file-utf8-win-linebr.bin", "UTF-8", 4}, {"test-file-utf8.bin", "UTF-8", null});
    }

    public ReversedLinesFileReaderTestParamFile(String fileName, String encoding, Integer buffsize) {
        this.fileName = fileName;
        this.encoding = encoding;
        this.buffSize = buffsize == null ? 4096 : buffsize;
    }

    @Test
    public void testDataIntegrityWithBufferedReader() throws URISyntaxException, IOException {
        File testFileIso = new File(this.getClass().getResource("/" + this.fileName).toURI());
        this.reversedLinesFileReader = new ReversedLinesFileReader(testFileIso, this.buffSize, this.encoding);
        Stack<String> lineStack = new Stack<String>();
        this.bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(testFileIso), this.encoding));
        String line = null;
        while ((line = this.bufferedReader.readLine()) != null) {
            lineStack.push(line);
        }
        while ((line = this.reversedLinesFileReader.readLine()) != null) {
            String lineFromBufferedReader = (String)lineStack.pop();
            Assert.assertEquals((Object)lineFromBufferedReader, (Object)line);
        }
    }

    @After
    public void closeReader() {
        try {
            this.bufferedReader.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.reversedLinesFileReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

