/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.UUID;
import junit.framework.TestCase;
import org.apache.commons.io.TaggedIOException;
import org.apache.commons.io.input.BrokenInputStream;
import org.apache.commons.io.input.ClosedInputStream;
import org.apache.commons.io.input.TaggedInputStream;

public class TaggedInputStreamTest
extends TestCase {
    public void testEmptyStream() {
        try {
            TaggedInputStream stream = new TaggedInputStream((InputStream)new ClosedInputStream());
            TaggedInputStreamTest.assertEquals((int)0, (int)stream.available());
            TaggedInputStreamTest.assertEquals((int)-1, (int)stream.read());
            TaggedInputStreamTest.assertEquals((int)-1, (int)stream.read(new byte[1]));
            TaggedInputStreamTest.assertEquals((int)-1, (int)stream.read(new byte[1], 0, 1));
            stream.close();
        }
        catch (IOException e) {
            TaggedInputStreamTest.fail((String)"Unexpected exception thrown");
        }
    }

    public void testNormalStream() {
        try {
            TaggedInputStream stream = new TaggedInputStream((InputStream)new ByteArrayInputStream(new byte[]{97, 98, 99}));
            TaggedInputStreamTest.assertEquals((int)3, (int)stream.available());
            TaggedInputStreamTest.assertEquals((int)97, (int)stream.read());
            byte[] buffer = new byte[1];
            TaggedInputStreamTest.assertEquals((int)1, (int)stream.read(buffer));
            TaggedInputStreamTest.assertEquals((int)98, (int)buffer[0]);
            TaggedInputStreamTest.assertEquals((int)1, (int)stream.read(buffer, 0, 1));
            TaggedInputStreamTest.assertEquals((int)99, (int)buffer[0]);
            TaggedInputStreamTest.assertEquals((int)-1, (int)stream.read());
            stream.close();
        }
        catch (IOException e) {
            TaggedInputStreamTest.fail((String)"Unexpected exception thrown");
        }
    }

    public void testBrokenStream() {
        IOException exception = new IOException("test exception");
        TaggedInputStream stream = new TaggedInputStream((InputStream)new BrokenInputStream(exception));
        try {
            stream.available();
            TaggedInputStreamTest.fail((String)"Expected exception not thrown.");
        }
        catch (IOException e) {
            TaggedInputStreamTest.assertTrue((boolean)stream.isCauseOf((Throwable)e));
            try {
                stream.throwIfCauseOf((Throwable)e);
                TaggedInputStreamTest.fail((String)"Expected exception not thrown.");
            }
            catch (IOException e2) {
                TaggedInputStreamTest.assertEquals((Object)exception, (Object)e2);
            }
        }
        try {
            stream.read();
            TaggedInputStreamTest.fail((String)"Expected exception not thrown.");
        }
        catch (IOException e) {
            TaggedInputStreamTest.assertTrue((boolean)stream.isCauseOf((Throwable)e));
            try {
                stream.throwIfCauseOf((Throwable)e);
                TaggedInputStreamTest.fail((String)"Expected exception not thrown.");
            }
            catch (IOException e2) {
                TaggedInputStreamTest.assertEquals((Object)exception, (Object)e2);
            }
        }
        try {
            stream.close();
            TaggedInputStreamTest.fail((String)"Expected exception not thrown.");
        }
        catch (IOException e) {
            TaggedInputStreamTest.assertTrue((boolean)stream.isCauseOf((Throwable)e));
            try {
                stream.throwIfCauseOf((Throwable)e);
                TaggedInputStreamTest.fail((String)"Expected exception not thrown.");
            }
            catch (IOException e2) {
                TaggedInputStreamTest.assertEquals((Object)exception, (Object)e2);
            }
        }
    }

    public void testOtherException() {
        IOException exception = new IOException("test exception");
        ClosedInputStream closed = new ClosedInputStream();
        TaggedInputStream stream = new TaggedInputStream((InputStream)closed);
        TaggedInputStreamTest.assertFalse((boolean)stream.isCauseOf((Throwable)exception));
        TaggedInputStreamTest.assertFalse((boolean)stream.isCauseOf((Throwable)new TaggedIOException(exception, (Serializable)UUID.randomUUID())));
        try {
            stream.throwIfCauseOf((Throwable)exception);
        }
        catch (IOException e) {
            TaggedInputStreamTest.fail((String)"Unexpected exception thrown");
        }
        try {
            stream.throwIfCauseOf((Throwable)new TaggedIOException(exception, (Serializable)UUID.randomUUID()));
        }
        catch (IOException e) {
            TaggedInputStreamTest.fail((String)"Unexpected exception thrown");
        }
    }
}

