/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import junit.framework.TestCase;
import org.apache.commons.io.output.ByteArrayOutputStream;

public class ByteArrayOutputStreamTestCase
extends TestCase {
    private static final byte[] DATA = new byte[64];

    public ByteArrayOutputStreamTestCase(String name) {
        super(name);
    }

    private int writeData(ByteArrayOutputStream baout, java.io.ByteArrayOutputStream ref, int count) {
        if (count > DATA.length) {
            throw new IllegalArgumentException("Requesting too many bytes");
        }
        if (count == 0) {
            baout.write(100);
            ref.write(100);
            return 1;
        }
        baout.write(DATA, 0, count);
        ref.write(DATA, 0, count);
        return count;
    }

    private int writeData(ByteArrayOutputStream baout, java.io.ByteArrayOutputStream ref, int[] instructions) {
        int written = 0;
        for (int instruction : instructions) {
            written += this.writeData(baout, ref, instruction);
        }
        return written;
    }

    private static boolean byteCmp(byte[] src, byte[] cmp) {
        for (int i = 0; i < cmp.length; ++i) {
            if (src[i] == cmp[i]) continue;
            return false;
        }
        return true;
    }

    private void checkByteArrays(byte[] expected, byte[] actual) {
        if (expected.length != actual.length) {
            ByteArrayOutputStreamTestCase.fail((String)"Resulting byte arrays are not equally long");
        }
        if (!ByteArrayOutputStreamTestCase.byteCmp(expected, actual)) {
            ByteArrayOutputStreamTestCase.fail((String)"Resulting byte arrays are not equal");
        }
    }

    private void checkStreams(ByteArrayOutputStream actual, java.io.ByteArrayOutputStream expected) {
        ByteArrayOutputStreamTestCase.assertEquals((String)"Sizes are not equal", (int)expected.size(), (int)actual.size());
        byte[] buf = actual.toByteArray();
        byte[] refbuf = expected.toByteArray();
        this.checkByteArrays(buf, refbuf);
    }

    public void testStream() throws Exception {
        ByteArrayOutputStream baout = new ByteArrayOutputStream(32);
        java.io.ByteArrayOutputStream ref = new java.io.ByteArrayOutputStream();
        int written = this.writeData(baout, ref, new int[]{4, 10, 22});
        ByteArrayOutputStreamTestCase.assertEquals((int)36, (int)written);
        this.checkStreams(baout, ref);
        written = this.writeData(baout, ref, new int[]{20, 12});
        ByteArrayOutputStreamTestCase.assertEquals((int)32, (int)written);
        this.checkStreams(baout, ref);
        baout.reset();
        ref.reset();
        written = this.writeData(baout, ref, new int[]{5, 47, 33, 60, 1, 0, 8});
        ByteArrayOutputStreamTestCase.assertEquals((int)155, (int)written);
        this.checkStreams(baout, ref);
        baout.reset();
        written = baout.write((InputStream)new ByteArrayInputStream(ref.toByteArray()));
        ByteArrayOutputStreamTestCase.assertEquals((int)155, (int)written);
        this.checkStreams(baout, ref);
        ByteArrayOutputStream baout1 = new ByteArrayOutputStream(32);
        ref.writeTo((OutputStream)baout1);
        java.io.ByteArrayOutputStream ref1 = new java.io.ByteArrayOutputStream();
        baout.writeTo((OutputStream)ref1);
        this.checkStreams(baout1, ref1);
        String baoutString = baout.toString("ASCII");
        String refString = ref.toString("ASCII");
        ByteArrayOutputStreamTestCase.assertEquals((String)"ASCII decoded String must be equal", (String)refString, (String)baoutString);
        ByteArrayOutputStreamTestCase.assertSame((Object)new ByteArrayOutputStream().toByteArray(), (Object)new ByteArrayOutputStream().toByteArray());
    }

    static {
        for (int i = 0; i < 64; i = (int)((byte)(i + 1))) {
            ByteArrayOutputStreamTestCase.DATA[i] = i;
        }
    }
}

