/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import junit.framework.AssertionFailedError;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.FileWriterWithEncoding;
import org.apache.commons.io.testtools.FileBasedTestCase;

public class FileWriterWithEncodingTest
extends FileBasedTestCase {
    private String defaultEncoding;
    private File file1;
    private File file2;
    private String textContent;

    public FileWriterWithEncodingTest(String name) {
        super(name);
    }

    public void setUp() {
        File encodingFinder = new File(FileWriterWithEncodingTest.getTestDirectory(), "finder.txt");
        OutputStreamWriter out = null;
        try {
            out = new OutputStreamWriter(new FileOutputStream(encodingFinder));
            this.defaultEncoding = out.getEncoding();
        }
        catch (IOException ex) {
            try {
                throw new RuntimeException(ex.getMessage());
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)out);
        this.file1 = new File(FileWriterWithEncodingTest.getTestDirectory(), "testfile1.txt");
        this.file2 = new File(FileWriterWithEncodingTest.getTestDirectory(), "testfile2.txt");
        char[] arr = new char[1024];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = (char)i;
        }
        this.textContent = new String(arr);
    }

    public void tearDown() throws Exception {
        FileUtils.deleteDirectory((File)FileWriterWithEncodingTest.getTestDirectory());
        this.defaultEncoding = null;
        this.textContent = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSameEncoding() throws Exception {
        FileWriter fw1 = null;
        FileWriterWithEncoding fw2 = null;
        try {
            fw1 = new FileWriter(this.file1);
            fw2 = new FileWriterWithEncoding(this.file2, this.defaultEncoding);
            FileWriterWithEncodingTest.assertTrue((boolean)this.file1.exists());
            FileWriterWithEncodingTest.assertTrue((boolean)this.file2.exists());
            fw1.write(this.textContent);
            fw2.write(this.textContent);
            fw1.flush();
            fw2.flush();
            this.checkFile(this.file1, this.file2);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fw1);
            IOUtils.closeQuietly(fw2);
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)fw1);
        IOUtils.closeQuietly((Writer)fw2);
        FileWriterWithEncodingTest.assertTrue((boolean)this.file1.exists());
        FileWriterWithEncodingTest.assertTrue((boolean)this.file2.exists());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDifferentEncoding() throws Exception {
        block11: {
            FileWriterWithEncoding fw2;
            FileWriter fw1;
            block10: {
                if (!Charset.isSupported("UTF-16BE")) break block10;
                fw1 = null;
                fw2 = null;
                try {
                    fw1 = new FileWriter(this.file1);
                    fw2 = new FileWriterWithEncoding(this.file2, this.defaultEncoding);
                    FileWriterWithEncodingTest.assertTrue((boolean)this.file1.exists());
                    FileWriterWithEncodingTest.assertTrue((boolean)this.file2.exists());
                    fw1.write(this.textContent);
                    fw2.write(this.textContent);
                    fw1.flush();
                    fw2.flush();
                    try {
                        this.checkFile(this.file1, this.file2);
                        FileWriterWithEncodingTest.fail();
                    }
                    catch (AssertionFailedError ex) {
                        // empty catch block
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fw1);
                    IOUtils.closeQuietly(fw2);
                    throw throwable;
                }
                IOUtils.closeQuietly((Writer)fw1);
                IOUtils.closeQuietly((Writer)fw2);
                FileWriterWithEncodingTest.assertTrue((boolean)this.file1.exists());
                FileWriterWithEncodingTest.assertTrue((boolean)this.file2.exists());
            }
            if (!Charset.isSupported("UTF-16LE")) break block11;
            fw1 = null;
            fw2 = null;
            try {
                fw1 = new FileWriter(this.file1);
                fw2 = new FileWriterWithEncoding(this.file2, this.defaultEncoding);
                FileWriterWithEncodingTest.assertTrue((boolean)this.file1.exists());
                FileWriterWithEncodingTest.assertTrue((boolean)this.file2.exists());
                fw1.write(this.textContent);
                fw2.write(this.textContent);
                fw1.flush();
                fw2.flush();
                try {
                    this.checkFile(this.file1, this.file2);
                    FileWriterWithEncodingTest.fail();
                }
                catch (AssertionFailedError assertionFailedError) {
                    // empty catch block
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly((Writer)fw1);
                IOUtils.closeQuietly(fw2);
                throw throwable;
            }
            IOUtils.closeQuietly((Writer)fw1);
            IOUtils.closeQuietly((Writer)fw2);
            FileWriterWithEncodingTest.assertTrue((boolean)this.file1.exists());
            FileWriterWithEncodingTest.assertTrue((boolean)this.file2.exists());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConstructor_File_encoding_badEncoding() {
        FileWriterWithEncoding writer = null;
        try {
            writer = new FileWriterWithEncoding(this.file1, "BAD-ENCODE");
            FileWriterWithEncodingTest.fail();
        }
        catch (IOException ex) {
            try {
                FileWriterWithEncodingTest.assertFalse((boolean)this.file1.exists());
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
            IOUtils.closeQuietly((Writer)writer);
        }
        IOUtils.closeQuietly((Writer)writer);
        FileWriterWithEncodingTest.assertFalse((boolean)this.file1.exists());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConstructor_File_directory() {
        FileWriterWithEncoding writer = null;
        try {
            writer = new FileWriterWithEncoding(FileWriterWithEncodingTest.getTestDirectory(), this.defaultEncoding);
            FileWriterWithEncodingTest.fail();
        }
        catch (IOException ex) {
            try {
                FileWriterWithEncodingTest.assertFalse((boolean)this.file1.exists());
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
            IOUtils.closeQuietly((Writer)writer);
        }
        IOUtils.closeQuietly((Writer)writer);
        FileWriterWithEncodingTest.assertFalse((boolean)this.file1.exists());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConstructor_File_nullFile() throws IOException {
        FileWriterWithEncoding writer = null;
        try {
            writer = new FileWriterWithEncoding((File)null, this.defaultEncoding);
            FileWriterWithEncodingTest.fail();
        }
        catch (NullPointerException ex) {
            try {
                FileWriterWithEncodingTest.assertFalse((boolean)this.file1.exists());
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
            IOUtils.closeQuietly((Writer)writer);
        }
        IOUtils.closeQuietly((Writer)writer);
        FileWriterWithEncodingTest.assertFalse((boolean)this.file1.exists());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConstructor_fileName_nullFile() throws IOException {
        FileWriterWithEncoding writer = null;
        try {
            writer = new FileWriterWithEncoding((String)null, this.defaultEncoding);
            FileWriterWithEncodingTest.fail();
        }
        catch (NullPointerException ex) {
            try {
                FileWriterWithEncodingTest.assertFalse((boolean)this.file1.exists());
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
            IOUtils.closeQuietly((Writer)writer);
        }
        IOUtils.closeQuietly((Writer)writer);
        FileWriterWithEncodingTest.assertFalse((boolean)this.file1.exists());
    }
}

