/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.UUID;
import junit.framework.TestCase;
import org.apache.commons.io.TaggedIOException;
import org.apache.commons.io.output.BrokenOutputStream;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.io.output.ClosedOutputStream;
import org.apache.commons.io.output.TaggedOutputStream;

public class TaggedOutputStreamTest
extends TestCase {
    public void testNormalStream() {
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            TaggedOutputStream stream = new TaggedOutputStream((OutputStream)buffer);
            stream.write(97);
            stream.write(new byte[]{98});
            stream.write(new byte[]{99}, 0, 1);
            stream.flush();
            stream.close();
            TaggedOutputStreamTest.assertEquals((int)3, (int)buffer.size());
            TaggedOutputStreamTest.assertEquals((int)97, (int)buffer.toByteArray()[0]);
            TaggedOutputStreamTest.assertEquals((int)98, (int)buffer.toByteArray()[1]);
            TaggedOutputStreamTest.assertEquals((int)99, (int)buffer.toByteArray()[2]);
        }
        catch (IOException e) {
            TaggedOutputStreamTest.fail((String)"Unexpected exception thrown");
        }
    }

    public void testBrokenStream() {
        IOException exception = new IOException("test exception");
        TaggedOutputStream stream = new TaggedOutputStream((OutputStream)new BrokenOutputStream(exception));
        try {
            stream.write(120);
            TaggedOutputStreamTest.fail((String)"Expected exception not thrown.");
        }
        catch (IOException e) {
            TaggedOutputStreamTest.assertTrue((boolean)stream.isCauseOf((Exception)e));
            try {
                stream.throwIfCauseOf((Exception)e);
                TaggedOutputStreamTest.fail((String)"Expected exception not thrown.");
            }
            catch (IOException e2) {
                TaggedOutputStreamTest.assertEquals((Object)exception, (Object)e2);
            }
        }
        try {
            stream.flush();
            TaggedOutputStreamTest.fail((String)"Expected exception not thrown.");
        }
        catch (IOException e) {
            TaggedOutputStreamTest.assertTrue((boolean)stream.isCauseOf((Exception)e));
            try {
                stream.throwIfCauseOf((Exception)e);
                TaggedOutputStreamTest.fail((String)"Expected exception not thrown.");
            }
            catch (IOException e2) {
                TaggedOutputStreamTest.assertEquals((Object)exception, (Object)e2);
            }
        }
        try {
            stream.close();
            TaggedOutputStreamTest.fail((String)"Expected exception not thrown.");
        }
        catch (IOException e) {
            TaggedOutputStreamTest.assertTrue((boolean)stream.isCauseOf((Exception)e));
            try {
                stream.throwIfCauseOf((Exception)e);
                TaggedOutputStreamTest.fail((String)"Expected exception not thrown.");
            }
            catch (IOException e2) {
                TaggedOutputStreamTest.assertEquals((Object)exception, (Object)e2);
            }
        }
    }

    public void testOtherException() {
        IOException exception = new IOException("test exception");
        ClosedOutputStream closed = new ClosedOutputStream();
        TaggedOutputStream stream = new TaggedOutputStream((OutputStream)closed);
        TaggedOutputStreamTest.assertFalse((boolean)stream.isCauseOf((Exception)exception));
        TaggedOutputStreamTest.assertFalse((boolean)stream.isCauseOf((Exception)new TaggedIOException(exception, (Serializable)UUID.randomUUID())));
        try {
            stream.throwIfCauseOf((Exception)exception);
        }
        catch (IOException e) {
            TaggedOutputStreamTest.fail((String)"Unexpected exception thrown");
        }
        try {
            stream.throwIfCauseOf((Exception)new TaggedIOException(exception, (Serializable)UUID.randomUUID()));
        }
        catch (IOException e) {
            TaggedOutputStreamTest.fail((String)"Unexpected exception thrown");
        }
    }
}

