package antipatternsrecovery.beans;

import java.util.Collection;
import java.util.Vector;

@SuppressWarnings("rawtypes")
public class ClassBean implements Comparable {
	 
	private String name;
	private Collection<InstanceVariableBean> instanceVariables;
	private String textContent;
	private Collection<MethodBean> methods;
	private Collection<String> imports;
	private PackageBean belongingPackage;
	private Integer LOC;

	public ClassBean() {
		name = null;
		instanceVariables = new Vector<InstanceVariableBean>();
		methods = new Vector<MethodBean>();
	}
	
	public String getName() {
		return name;
	}
	
	public void setName(String pName) {
		name = pName;
	}
	
	public Collection<InstanceVariableBean> getInstanceVariables() {
		return instanceVariables;
	}
	
	public void setInstanceVariables(Collection<InstanceVariableBean> pInstanceVariables) {
		instanceVariables = pInstanceVariables;
	}
	
	public void addInstanceVariables(InstanceVariableBean pInstanceVariable) {
		instanceVariables.add(pInstanceVariable);
	}
	
	public void removeInstanceVariables(InstanceVariableBean pInstanceVariable) {
		instanceVariables.remove(pInstanceVariable);
	}
	
	public Collection<MethodBean> getMethods() {
		return methods;
	}
	
	public void setMethods(Collection<MethodBean> pMethods) {
		methods = pMethods;
	}
	
	public void addMethod(MethodBean pMethod) {
		methods.add(pMethod);
	}
	
	public void removeMethod(MethodBean pMethod) {
		methods.remove(pMethod);
	}
	
	public String toString() {
		return 
			"name = " + name + "\n" +
			"instanceVariables = " + instanceVariables + "\n" +
			"methods = " + methods + "\n";
	}

	public int compareTo(Object pClassBean) {
		return this.getName().compareTo(((ClassBean)pClassBean).getName());
	}

	public PackageBean getBelongingPackage() {
		return belongingPackage;
	}

	public void setBelongingPackage(PackageBean belongingPackage) {
		this.belongingPackage = belongingPackage;
	}

	public String getTextContent() {
		return textContent;
	}

	public void setTextContent(String textContent) {
		this.textContent = textContent;
	}
	
	public int getLOC() {
		return LOC;
	}

	public void setLOC(int lOC) {
		LOC = lOC;
	}
	
	public Collection<String> getImports() {
		return imports;
	}

	public void setImports(Collection<String> imports) {
		this.imports = imports;
	}
	
}
