package antipatternsrecovery.beans;

import java.util.Collection;
import java.util.List;
import java.util.Vector;

import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;

@SuppressWarnings("rawtypes")
public class MethodBean implements Comparable {
	
	private String name;
	private Type returnType;
	private String textContent;
	private List<SingleVariableDeclaration> parameters;
	private Collection<InstanceVariableBean> usedInstanceVariables;
	private Collection<MethodBean> methodCalls;
	private ClassBean belongingClass;
	private boolean staticMethod;
	private boolean isDefaultCostructor;
	
	public MethodBean() {
		name = null;
		textContent = null;
		usedInstanceVariables = new Vector<InstanceVariableBean>();
		methodCalls = new Vector<MethodBean>();
	}
	
	public String getName() {
		return name;
	}
	
	public void setName(String pName) {
		name = pName;
	}
	
	public String getTextContent() {
		return textContent;
	}
	
	public void setTextContent(String pTextContent) {
		textContent = pTextContent;
	}
	
	public Collection<InstanceVariableBean> getUsedInstanceVariables() {
		return usedInstanceVariables;
	}
	
	public void setUsedInstanceVariables(Collection<InstanceVariableBean> pUsedInstanceVariables) {
		usedInstanceVariables = pUsedInstanceVariables;
	}
	
	public void addUsedInstanceVariables(InstanceVariableBean pInstanceVariable) {
		usedInstanceVariables.add(pInstanceVariable);
	}
	
	public void removeUsedInstanceVariables(InstanceVariableBean pInstanceVariable) {
		usedInstanceVariables.remove(pInstanceVariable);
	}
	
	public Collection<MethodBean> getMethodCalls() {
		return methodCalls;
	}
	
	public void setMethodCalls(Collection<MethodBean> pMethodCalls) {
		methodCalls = pMethodCalls;
	}
	
	public void addMethodCalls(MethodBean pMethodCall) {
		methodCalls.add(pMethodCall);
	}
	
	public void removeMethodCalls(MethodBean pMethodCall) {
		methodCalls.remove(pMethodCall);
	}

	public int compareTo(Object o) {
		return this.getName().compareTo(((MethodBean)o).getName());
	}

	public ClassBean getBelongingClass() {
		return belongingClass;
	}

	public void setBelongingClass(ClassBean belongingClass) {
		this.belongingClass = belongingClass;
	}

	public boolean isStaticMethod() {
		return staticMethod;
	}

	public void setStaticMethod(boolean staticMethod) {
		this.staticMethod = staticMethod;
	}

	public boolean isDefaultCostructor() {
		return isDefaultCostructor;
	}

	public void setDefaultCostructor(boolean isDefaultCostructor) {
		this.isDefaultCostructor = isDefaultCostructor;
	}

	public Type getReturnType() {
		return returnType;
	}

	public void setReturnType(Type returnType) {
		this.returnType = returnType;
	}

	public List<SingleVariableDeclaration> getParameters() {
		return parameters;
	}

	public void setParameters(List<SingleVariableDeclaration> parameters) {
		this.parameters = parameters;
	}
	
	public String toString() {
		String string =
			"(" + name + "|" +
			(textContent.length() > 10 ? textContent.replace("\n", " ").replace("\t", "").substring(0, 10).concat("...") : "") + "|";
			
		for (InstanceVariableBean usedInstanceVariable : usedInstanceVariables)
			string += usedInstanceVariable.getName() + ",";
		string = string.substring(0, string.length() - 1);
		string += "|";
		
		for (MethodBean methodCall : methodCalls)
			string += methodCall.getName() + ",";
		string = string.substring(0, string.length() - 1);
		string += ")";
		
		return string;	
	}
}