package antipatternsrecovery.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;

/**
 * Our sample handler extends AbstractHandler, an IHandler base class.
 * @see org.eclipse.core.commands.IHandler
 * @see org.eclipse.core.commands.AbstractHandler
 */
public class AntipatternsRecoveryHandler extends AbstractHandler {
	/**
	 * The constructor.
	 */
	public AntipatternsRecoveryHandler() {
	}

	/**
	 * the command has been executed, so extract extract the needed information
	 * from the application context.
	 */
	@SuppressWarnings("unused")
	public Object execute(ExecutionEvent event) throws ExecutionException {
		IJavaProject[] toAnalyze;
		IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked(event);
		IStructuredSelection selection = (IStructuredSelection) 
				HandlerUtil.getActiveSite(event).getSelectionProvider().getSelection();
		if(selection == null)
			return null;

		Object[] elements = selection.toArray();
		toAnalyze=new IJavaProject[elements.length];
		int i=0;
		for(Object o: elements){
			if(o instanceof IJavaProject) {
				IJavaProject javaProject= (IJavaProject) o;
				toAnalyze[i]=javaProject;
				i++;
			}
		}

		return elements;
	}
}
