package antipatternsrecovery.metrics;

import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

public class NOV {
	private int numberOfMethodsWithoutVariables;

	public int computeNOV(ICompilationUnit pClass) {
		int counter = 0;

		if(pClass.exists()) {
			try {
				// Getting class name from compilation unit
				IType type = pClass.getType(pClass.getElementName().substring(0, pClass.getElementName().length()-5));

				if(type.exists()) {
					if(type.getFields().length == 0)
						this.numberOfMethodsWithoutVariables++;

					for(@SuppressWarnings("unused") IField field: type.getFields()){
						counter++;
					}
				} else counter=0;
			} catch (JavaModelException e) {
				e.printStackTrace();
			}
		}
		return counter;
	}

	public int getNumberOfMethodsWithoutVariables() {
		return this.numberOfMethodsWithoutVariables;
	}
}