package antipatternsrecovery.metrics;

import java.util.Vector;

import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;

import antipatternsrecovery.parsingElements.MethodDeclarationsVisitor;
import antipatternsrecovery.parsingElements.MethodInvocationsVisitor;
import antipatternsrecovery.parsingElements.Parser;

/*
public class ClassA 
{
  private ClassB classB = new ClassB();        // call (constructor of class B) => +1
  public void doSomething(){                   // method declaration => +1
    System.out.println ( "doSomething");       // call (System.out.println) => +1
  }
  public void doSomethingBasedOnClassB(){      // method declaration => +1
    System.out.println (classB.toString());    // call (System.out.println) => 0 because already counted on line 5 + call (toString) => +1
  }
}

// default constructor of ClassA => +1
// RFC = 6
 */
public class RFC {

	public int computeRFC(ICompilationUnit pClass) {
		int rfc=0;
		Vector<MethodInvocation> alreadyAdded=new Vector<MethodInvocation>();

		MethodDeclarationsVisitor methodDeclarationVisitor=new MethodDeclarationsVisitor();
		MethodInvocationsVisitor methodInvocationVisitor=new MethodInvocationsVisitor();

		if(pClass.exists()) {
			try {
				Parser parser=new Parser(pClass.getSource());
				CompilationUnit unit = parser.createParser();

				unit.accept(methodDeclarationVisitor);

				for(MethodDeclaration methodDecl:methodDeclarationVisitor.getMethods()) {
					rfc++;
				}

				unit.accept(methodInvocationVisitor);

				for(MethodInvocation methodInvocation: methodInvocationVisitor.getMethods()) {
					if(! alreadyAdded.contains(methodInvocation))
						rfc++;
				}

			} catch (JavaModelException e) {
				e.printStackTrace();
			}
		}
		return rfc;

	}
}
