package antipatternsrecovery.parsingElements;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.MethodInvocation;

	/**
	 * This class allows to visit the MethodInvocation node (i.e.: example.getX()) of the AST representing the Class;
	 *
	 * @author Fabio Palomba;
	 */
	public class FieldAccessVisitor extends ASTVisitor {
		private List<FieldAccess> fields = new ArrayList<FieldAccess>();
	

		@Override
			public boolean visit(FieldAccess node) {
			fields.add(node);
		
			  return super.visit(node);
			}

		public Collection<FieldAccess> getFields() {
				return fields;			
			}
	}