

package antipatternsrecovery.parsingElements;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.MethodDeclaration;

	/**
	 * This class allows to visit the MethodDeclaration node (i.e.: a method) of the AST representing the Class;
	 *
	 * @author Fabio Palomba;
	 */

	public class MethodDeclarationsVisitor extends ASTVisitor {
		private List<MethodDeclaration> methods = new ArrayList<MethodDeclaration>();

		
		@Override
			public boolean visit(MethodDeclaration node) {
					methods.add(node);
				
			  return super.visit(node);
			}

			/**
			 * This method allows to get all the MethodDeclaration for the Class on which it is;
			 * 
			 * @return
			 * 				a List of all MethodDeclaration;
			 */
			public List<MethodDeclaration> getMethods() {
				return methods;
			}

			/**
			 * This method allows to get a specific MethodDeclaration given an index;
			 * 
			 * @param pIndex
			 * 				the index of the MethodDeclaration to get;
			 * @return
			 * 				the MethodDeclaration corresponding to the index;
			 */
			public MethodDeclaration getDeclaration(int pIndex) {
				return methods.get(pIndex);
			}
	}