
package antipatternsrecovery.parsingElements;

import org.eclipse.jdt.core.dom.*;

	public class Parser {
		private char[] charClass;
		private CompilationUnit unit;
		private ASTParser parser;

				public Parser(){}
				
				public Parser (String pClassToAnalyze) { 
					this.charClass=pClassToAnalyze.toCharArray();
				}	

				public CompilationUnit createParser() {
		 			parser = ASTParser.newParser(AST.JLS4);
		 			parser.setKind(ASTParser.K_COMPILATION_UNIT);
		 			parser.setSource(this.charClass); 
		 			parser.setResolveBindings(true); 
		 			return (CompilationUnit) parser.createAST(null);
		 		}
		 		
				public CompilationUnit createParser(String pMethod, boolean isMethod) {
		 			parser = ASTParser.newParser(AST.JLS4);
		 			parser.setKind(ASTParser.K_COMPILATION_UNIT);
		 			parser.setSource(pMethod.toCharArray()); 
		 			parser.setResolveBindings(true); 
		 			return (CompilationUnit) parser.createAST(null);
		 		}
				
				public TypeDeclaration createParser(String pClass) {
		 			parser = ASTParser.newParser(AST.JLS4);
		 			parser.setKind(ASTParser.K_CLASS_BODY_DECLARATIONS);
		 			parser.setSource(pClass.toCharArray()); 
		 			
		 			return (TypeDeclaration) parser.createAST(null);
		 		}
				
				public TypeDeclaration createParser(String pMethod, int pType) {
		 			parser = ASTParser.newParser(AST.JLS4);
		 			parser.setKind(ASTParser.K_COMPILATION_UNIT);
		 			parser.setSource(pMethod.toCharArray()); 
		 			
		 			return (TypeDeclaration) parser.createAST(null);
		 		}
				
				public CompilationUnit createEmptyParser(){
		 			parser = ASTParser.newParser(AST.JLS4);
		 			parser.setSource(" ".toCharArray());		
		 			unit = (CompilationUnit) parser.createAST(null);
		 			unit.recordModifications();
		 			//AST ast = unit.getAST(); 
		 			return unit;
		 		}
		 		
		 		public CompilationUnit getCompilationUnit(){
		 			return this.unit;
		 		}
	}